<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CourseChapterController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

   public function showCourseChapter(Request $request, $courseId)
    {
        $user = auth()->user();
        if (!$user) {
            return redirect()->route('login');
        }

   
        $procedureName = 'IsUserEnrolledInCourse';
        $userId = $user->StudentID;
        DB::statement("CALL {$procedureName}(?, ?, @isEnrolled)", [$userId, $courseId]);
        $isEnrolledResult = DB::select("SELECT @isEnrolled as isEnrolled");

        if (!$isEnrolledResult || !(bool)$isEnrolledResult[0]->isEnrolled) {
            return redirect()->route('courses');
        }

        
        $course = DB::table('COURSES')->where('CourseID', $courseId)->first();

      
        $units = DB::table('UNITS')->where('CourseID', $courseId)->get();

        foreach ($units as $unit) {
           
            $lessons = DB::table('LESSONS')->where('UnitID', $unit->UnitID)->get();
            foreach ($lessons as $lesson) {
                $lesson->content = json_decode($lesson->LessonContent, true);
            }
            $unit->lessons = $lessons;

        
            $exercises = DB::table('EXERCISES')
                           ->where('UnitID', $unit->UnitID)
                           ->get()->map(function ($exercise) {
                                $exercise->content = json_decode($exercise->Content, true);
                                return $exercise;
                            });

            $unit->exercises = $exercises;
            
            $recordings = DB::table('RECORDINGS')
                        ->where('UnitID', $unit->UnitID)
                        ->get()->map(function ($recording) {
                            $recording->content = json_decode($recording->RecordingContent, true);
                            return $recording;
                        });
        $unit->recordings = $recordings;
        
        
            
            $practicesInClass = DB::table('PRACTICECLASS')
                       ->where('UnitID', $unit->UnitID)
                       ->get()->map(function ($practice) {
                            $practice->content = json_decode($practice->PracticeClassContent, true);
                            return $practice;
                        });
$unit->practicesInClass = $practicesInClass;

$practicesAtHome = DB::table('PRACTICEHOME')
                       ->where('UnitID', $unit->UnitID)
                       ->get()->map(function ($practicehome) {
                            $practicehome->content = json_decode($practicehome->PracticeHomeContent, true);
                            return $practicehome;
                        });
$unit->practicesAtHome = $practicesAtHome;


            
    }

    return view('CourseChapter', compact('user', 'course', 'units'));
}



        }
        

     
