<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ProfileController extends Controller
{
    public function showProfile() {
        $user = Auth::user(); // Get the authenticated user

        if ($user) {
            Log::info('User found', ['user' => $user]);
            $userId = $user->StudentID; 

         
            $userId = (int) $userId;
            Log::info('User ID', ['userId' => $userId]);

            try {
            
                $coursesInfo = DB::select('CALL GetUserCoursesInfo(?)', [$userId]);
                Log::info('Courses info retrieved', ['coursesInfo' => $coursesInfo]);

             
                return view('Profile', compact('user', 'coursesInfo'));
            } catch (\Exception $e) {
                Log::error('Error executing stored procedure', ['exception' => $e->getMessage()]);
                return view('Profile')->with('error', 'Error fetching courses info!');
            }

        } else {
            Log::warning('No user found in session');
            return view('Profile')->with('error', 'User not found!');
        }
    }
}
