<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\Session;


class RegisterController extends Controller
{
    public function showRegister() {
        return view('Register');
    }


    public function create(Request $request)
    {

        $request->validate([
            'email' => 'required|email',
        //     'confirm_email' => 'required|same:email', 
         'password' => 'required|min:8|regex:/[A-Z]/|regex:/[@$!%*#?&]/', 
        //     'confirm_password' => 'required|same:password',
        'photoprofile' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048', 
        'photopassport' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048', 
        'photoid' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        'phone' => 'required|digits_between:6,20', 
  
        ]);

        $firstName = $request->input('first-name');
        $lastName = $request->input('last-name');
        $username = $request->input('username');
        $email = $request->input('email');
        $password = Hash::make($request->input('password'));
        $phone = $request->input('phone');
        $city = $request->input('city');
        $state = $request->input('state');
        $address = $request->input('address');
        $country = $request->input('country');
        $biography = $request->input('biography');
        $photoprofile = $request->input('photoprofile');
        $photopassport = $request->input('photopassport');
        $photoid = $request->input('photoid');
    
        $currentDate = Carbon::now()->toDateString();
        $oneYearFromNow = Carbon::now()->addYear()->toDateString();


        if ($request->hasFile('photoprofile')) {
            $profilePhoto = $request->file('photoprofile');
            $profileName = time() . '.' . $profilePhoto->getClientOriginalExtension();
            $profilePhoto->move(public_path('uploads/profile_photos'), $profileName);
            $photoprofile = 'uploads/profile_photos/' . $profileName;
        }
        
         if ($request->hasFile('photopassport')) {
        $passportPhoto = $request->file('photopassport');
        $passportName = time() . '.' . $passportPhoto->getClientOriginalExtension();
        $passportPhoto->move(public_path('uploads/passport_photos'), $passportName);
        $photopassport = 'uploads/passport_photos/' . $passportName;
    }
    
      if ($request->hasFile('photoid')) {
        $idPhoto = $request->file('photoid');
        $idName = time() . '.' . $idPhoto->getClientOriginalExtension();
        $idPhoto->move(public_path('uploads/id_photos'), $idName);
        $photoid = 'uploads/id_photos/' . $idName;
    }

        try {
            DB::select('CALL InsertUser(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)', 
            [$firstName, $lastName, 
            $username, $email, 
            $password, $phone,
            $city, $state,
            $address, $country,
            $biography,  $photoprofile,
             $photopassport, $photoid, 
            'BASIC', '1',
            $currentDate, $oneYearFromNow,
            $currentDate, NULL, 
            NULL, '0', 
            '2']);

 
    
            return redirect()->route('login')->with('status', 'User registered successfully!');
        } catch (QueryException $e) {
            if ($e->errorInfo[1] == 1062) {
                // Specific handling for the 'Duplicate entry' error
                if (strpos($e->getMessage(), 'Username') !== false) {
                    return redirect()->back()->with('error', "The username '$username' already exists. Please choose another one.");
                }
                // If you also have unique constraints on other fields (like email), handle them here:
                if (strpos($e->getMessage(), 'Email') !== false) {
                    return redirect()->back()->with('error', "The email '$email' is already in use. Please use a different one.");
                }
            }
            // If it's another type of error, just show a generic message.
            return redirect()->back()->with('error', 'There was an error registering the user.');
        } catch (\Exception $e) {
            // For other non-database exceptions
            return redirect()->back()->with('error', 'There was an error registering the user: ' . $e->getMessage());
        }
    }


}
