<?php

namespace App\Models;

use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

namespace App\Models;

use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $table = 'USERS'; // Specifying the table name

    protected $primaryKey = 'StudentID'; // Specifying the custom primary key

    public $incrementing = false; // If the primary key is not auto-incrementing, set this to false

    protected $fillable = [
        'Username',
        'Email',
        'Password',
    ];

    protected $hidden = [
        'Password',
    ];

    // Specify the password column for Laravel's built-in Auth
    public function getAuthPassword()
    {
        return $this->Password;
    }
}

?>