
  



    // Function to scroll to the top of the page
    function scrollToTop() {
        window.scrollTo({
            top: 0,
            behavior: 'smooth' // Add smooth scrolling effect
        });
    }

    // Add a click event listener to the back-to-top button
    document.getElementById('back-to-top').addEventListener('click', scrollToTop);

    // Function to handle the scroll event
    function handleScroll() {
        var backToTopButton = document.getElementById('back-to-top');
        if (window.scrollY > 0) {
            // User has started scrolling down, display the button
            backToTopButton.style.display = 'block';
        } else {
            // User is at the top of the page, hide the button
            backToTopButton.style.display = 'none';
        }
    }

    // Add a scroll event listener to handle showing/hiding the button
    window.addEventListener('scroll', handleScroll);




  window.addEventListener('load', function () {
    var preloader = document.getElementById('preloader');
    preloader.style.display = 'none';
  });



        document.addEventListener("DOMContentLoaded", function () {
            const dropdown = document.querySelector(".dropdown");
            const dropdownButton = dropdown.querySelector(".dropbtn");
            const dropdownContent = dropdown.querySelector(".dropdown-content");

            // Handle click on the document to close the dropdown
            document.addEventListener("click", function (event) {
                if (!dropdown.contains(event.target)) {
                    dropdown.classList.remove("active");
                }
            });

            dropdownButton.addEventListener("click", function () {
                dropdown.classList.toggle("active");
            });

            // Handle option click
            const dropdownLinks = document.querySelectorAll(".dropdown-content a");
            dropdownLinks.forEach(function (link) {
                link.addEventListener("click", function (e) {
                    // The default behavior (navigating to the href) will occur
                    // when the user clicks an option.
                });
            });
        });
 




document.addEventListener('DOMContentLoaded', function() {
    const hamburger = document.querySelector('.hamburger');
    const menu = document.querySelector('.menu');
    const bars = document.querySelectorAll('.bar');
    const closeButton = document.getElementById('close-button');

    hamburger.addEventListener('click', function() {
        menu.classList.toggle('active');
        bars.forEach(bar => bar.classList.toggle('active'));
    });

    closeButton.addEventListener('click', function() {
        menu.classList.remove('active');
        bars.forEach(bar => bar.classList.remove('active'));
    });
});


const navLinks = document.querySelectorAll(".nav-link");
const homeLink = document.querySelector("#active");


navLinks.forEach((link) => {
  link.addEventListener("mouseenter", () => {
    // Remove the 'active' class from all links
    navLinks.forEach((navLink) => {
      navLink.classList.remove("active");
    });
    // Add the 'active' class to the hovered link
    link.classList.add("active");
  });
});

homeLink.addEventListener("mouseenter", () => {
  // Add the 'active' class back to the Home link when moving away from links
  homeLink.classList.add("active");
});

// On mouseleave from the navbar, remove the 'active' class from all links
document.querySelector(".navbar").addEventListener("mouseleave", () => {
  navLinks.forEach((navLink) => {
    navLink.classList.remove("active");
  });
  // Add the 'active' class back to the Home link
  homeLink.classList.add("active");
});

