<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<link rel="preload" href="{{ asset('images/Contact 2.jpg') }}" as="image">
<link rel="icon" href="{{ asset('images/favicon.png') }}" type="image/x-icon">
<link href="{{ asset('css/Contact.css') }}" rel="stylesheet">


    <title>Contact</title>


</head>

<body>


<div id="preloader">
  <div id="logo-container">
    <img src="{{ asset('images/Edtech-logo.png') }}" alt="Logo">
  </div>
</div>

 <button id="back-to-top" style="display: none;" class="scroll-top-button">&#9650;</button>



 @include('Header')
 
    <div class="backgroundimage">
    <img src="{{ asset('images/Contact.jpg') }}" alt="Main Image">
</div>

<br><br><br>


@if(session('success'))
    <div class="alert alert-success" style="text-align: center; margin-top: -40px; margin-left:750px; padding: 10px; background-color: #dff0d8; border-color: #d0e9c6; color: #3c763d;">
        {{ session('success') }}
    </div>
@endif


<div class="terms-text">
    <br><br>
<h1>Contact</h1>

<table style="border: none; width: 100%;">
  <tr>
  
    <td style="border: none; vertical-align: top; padding-right: 20px;">
      <h2>EdTech Plus Ltd.</h2>
      <p>Welcome to our Website. We are glad to have you around.</p>
      <p><b>Phone</b><br><span class="icon">&#128222; <a href="tel:+442034750264" style="text-decoration: none; color: blue;">+442034750264</a></span></p>
      <p><b>Mail</b><br><span class="icon">&#9993; <a href="mailto:info@edtechplus.com" style="text-decoration: none; color: blue;">info@edtechplus.com</a></span></p>
      <p><b>Address</b><br>57 Rathbone Place, London, England, W1T 1JU</p>
      <div class="social-icons">
       
        <a href="https://www.facebook.com/edtechplusofficial" target="_blank" class="social-icon" style="text-decoration: none; color: black;"><i class="fab fa-facebook"></i></a>
        <a href="https://www.linkedin.com/company/edtech-plus" target="_blank" class="social-icon" style="text-decoration: none; color: black;"><i class="fab fa-linkedin"></i></a>
        <a href="https://www.instagram.com/Edtechplus/" target="_blank" class="social-icon" style="text-decoration: none; color: black;"><i class="fab fa-instagram"></i></a>
      </div>
    </td>
    
<td style="border: none; vertical-align: top;">
  <div class="login-container" style="margin-top: 5px;">
    <h1>Send a Message</h1>
    <form id="login-form" method="post" action="{{ route('store.message') }}">
    @csrf
      <div class="form-group">
        <label for="firstName">First Name</label>
        <input type="text" id="firstName" name="firstName" required>
      </div>
      <div class="form-group">
        <label for="lastName">Last Name</label>
        <input type="text" id="lastName" name="lastName" required>
      </div>
      <div class="form-group">
        <label for="message">Message</label>
        <textarea id="message" name="message" required style="width: 325px; height: 150px;"></textarea>
      </div>
      <button type="submit">Send</button>
    </form>
  </div>
</td>
</tr>

</table>

</div>

<br>
<br>
<br>

<h2 style="margin-left: 100px;">Location on map</h2>
  <p style="margin-left: 100px;">4th floor, 57 Rathbone Place, London W1T 1JU UK.</p>
<br>
    <div style="width: 100%; height: 400px;">
        <iframe
            width="100%"
            height="100%"
            frameborder="0"
            scrolling="no"
            marginheight="0"
            marginwidth="0"
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3153.3345224978255!2d-122.0844635846818!3d37.4219998798271!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x808f7e15c43450b9%3A0x3fd774c28ab1307a!2sGolden%20Gate%20Bridge!5e0!3m2!1sen!2sus!4v1627484558980!5m2!1sen!2sus618"
            allowfullscreen
        ></iframe>
    </div>




<br><br><br><br>



</div>

@include('Footer')
    


<script src="{{ asset('js/Contact.js') }}"></script>

<script>
 document.addEventListener('DOMContentLoaded', function () {
        var navbar = document.getElementById('navbar');
        var navLinks = document.querySelectorAll('.navbar a');
        var logoImage = document.getElementById('navbar-logo');
        var languageLinks = document.querySelectorAll('.dropdown-content a'); 
        var languageText = document.querySelectorAll('.selected-text');
  var hamburger = document.querySelectorAll('.hamburger');
  var dropdown = document.querySelectorAll('.dropdown-icon');


  var initialLogoSrc = '{{ asset('images/Edtech-logo-white-01-768x151-1.png') }}';
var scrolledLogoSrc = '{{ asset('images/Edtech-logo.png') }}';


        window.addEventListener('scroll', function () {
            if (window.scrollY > 0) {
                navbar.style.backgroundColor = 'white';
                navbar.style.color = 'black';

                navLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

                // Change the text color of language menu items to black
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

 dropdown.forEach(function (link) {
                    link.style.color = 'black';
                });

 languageText.forEach(function (link) {
                    link.style.color = 'black';
                });

                logoImage.src = scrolledLogoSrc;
            } else {
                navbar.style.backgroundColor = 'black';
                navbar.style.color = 'white';
                navLinks.forEach(function (link) {
                    link.style.color = 'white';
                });

                // Change the text color of language menu items to white
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });
 dropdown.forEach(function (link) {
                    link.style.color = 'white';
                });
 languageText.forEach(function (link) {
                    link.style.color = 'white';
                });

                logoImage.src = initialLogoSrc;
            }
        });
    });

</script>


</body>
</html>