<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<link rel="preload" href="{{ asset('images/Contact 2.jpg') }}" as="image">
<link rel="icon" href="{{ asset('images/favicon.png') }}" type="image/x-icon">
<link href="{{ asset('css/CourseDetails.css') }}" rel="stylesheet">

    <title>Course Details</title>

  <style>

.title-and-button {
  display: flex;
  justify-content: flex-start;
  align-items: center;
  gap: 10px;
}

.price-and-button-container {
    display: flex;
    justify-content: flex-end; 
    align-items: center;
    gap: 10px;
}

.course-price {
    font-size: 2rem;
    color: red;
    font-weight: bold;
}

.buy-button {
    background-color: #90EE90;
    color: white;
    border: none;
    padding: 15px 30px;
    font-size: 1rem;
    cursor: pointer;
    border-radius: 5px;
}

.course-detail-container h1 {
    margin-bottom: 0.5em; 
    font-size: 2rem; 
    font-weight: 
}


  </style>

</head>

<body>


<div id="preloader">
  <div id="logo-container">
  <img src="{{ asset('images/Edtech-logo.png') }}" alt="Logo">
  </div>
</div>

 <button id="back-to-top" style="display: none;" class="scroll-top-button">&#9650;</button>



 </div>
@include('Header')

    <div class="backgroundimage">
    <img src="{{ asset('images/Contact 2.jpg') }}" alt="Main Image">
    <br><br><br>
</div>
<div class="privacypolicy-text">

   <h1>{{ $course->CourseName }}</h1>
   <div class="price-and-button-container">
    <span class="course-price">Price: US${{ $course->CoursePrice }}</span>
    @if ($userEnrolled)
     
     <button class="buy-button" onclick="window.location.href='{{ url('/coursechapter/' . $course->CourseID) }}'">Continue</button>

@else
    <button class="buy-button" onclick="window.location.href='{{ route('checkout') }}?courseId={{ $course->CourseID }}'">Buy</button>
@endif

</div>


  
    <img src="{{ asset($course->CourseImage) }}" alt="{{ $course->CourseName }} Image" width="300">
    <p>Author: {{ $course->CourseAuthor }}</p>
    <p>Description: {{ $course->CourseDescription }}</p>
    <p>Duration: {{ $course->CourseDuration }}</p>
    <p>{{ $course->CourseCertificate ? 'Certificate Available' : 'No Certificate' }}</p>
  
</div>


<br><br><br><br>




@include('Footer')


<script src="{{ asset('js/CourseDetails.js') }}"></script>

<script>
 document.addEventListener('DOMContentLoaded', function () {
        var navbar = document.getElementById('navbar');
        var navLinks = document.querySelectorAll('.navbar a');
        var logoImage = document.getElementById('navbar-logo');
        var languageLinks = document.querySelectorAll('.dropdown-content a');
        var languageText = document.querySelectorAll('.selected-text');
  var hamburger = document.querySelectorAll('.hamburger');
  var dropdown = document.querySelectorAll('.dropdown-icon');

  var initialLogoSrc = '{{ asset('images/Edtech-logo-white-01-768x151-1.png') }}';
var scrolledLogoSrc = '{{ asset('images/Edtech-logo.png') }}';

        window.addEventListener('scroll', function () {
            if (window.scrollY > 0) {
                navbar.style.backgroundColor = 'white';
                navbar.style.color = 'black';

                navLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

          
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

 dropdown.forEach(function (link) {
                    link.style.color = 'black';
                });

 languageText.forEach(function (link) {
                    link.style.color = 'black';
                });

                logoImage.src = scrolledLogoSrc;
            } else {
                navbar.style.backgroundColor = 'black';
                navbar.style.color = 'white';
                navLinks.forEach(function (link) {
                    link.style.color = 'white';
                });

   
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });
 dropdown.forEach(function (link) {
                    link.style.color = 'white';
                });
 languageText.forEach(function (link) {
                    link.style.color = 'white';
                });

                logoImage.src = initialLogoSrc;
            }
        });
    });

</script>

</body>
</html>