<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<link rel="preload" href="{{ asset('images/Contact 2.jpg') }}" as="image">
<link rel="icon" href="{{ asset('images/favicon.png') }}" type="image/x-icon">
<link href="{{ asset('css/Courses.css') }}" rel="stylesheet">

    <title>Courses</title>

  

</head>

<body>


<div id="preloader">
  <div id="logo-container">
  <img src="{{ asset('images/Edtech-logo.png') }}" alt="Logo">
  </div>
</div>

 <button id="back-to-top" style="display: none;" class="scroll-top-button">&#9650;</button>



 </div>
@include('Header')

    <div class="backgroundimage">
    <img src="{{ asset('images/Contact 2.jpg') }}" alt="Main Image">
    <br><br><br>
</div>
<div class="privacypolicy-text">
<h1>Courses</h1>


<div class="scroll-container">
    <table>
        <tr>
          @foreach($courses as $course)
    <td class="coursescard">
        <a href="{{ route('coursedetails', $course->CourseID) }}" rel="bookmark">
            <img src="{{ asset($course->CourseImage) }}" alt="Image" width="300">
            <p>{{ $course->CourseAuthor }}</p>
            <h2>{{ $course->CourseName }}</h2>
            <div class="numbers">
                <span class="logo-paper">&#128196;</span> 
                {{ $course->CourseDuration }}
                <span class="price"><b style="color: orange;">US${{ $course->CoursePrice }}</b></span>
            </div>
            <p>{{ $course->CourseCertificate ? 'Certificate Available' : 'No Certificate' }}</p> 
        </a>
    </td>
@endforeach

        </tr>
    </table>
</div>


<br><br><br><br>




@include('Footer')


<script src="{{ asset('js/Courses.js') }}"></script>

<script>
 document.addEventListener('DOMContentLoaded', function () {
        var navbar = document.getElementById('navbar');
        var navLinks = document.querySelectorAll('.navbar a');
        var logoImage = document.getElementById('navbar-logo');
        var languageLinks = document.querySelectorAll('.dropdown-content a');
        var languageText = document.querySelectorAll('.selected-text');
  var hamburger = document.querySelectorAll('.hamburger');
  var dropdown = document.querySelectorAll('.dropdown-icon');

  var initialLogoSrc = '{{ asset('images/Edtech-logo-white-01-768x151-1.png') }}';
var scrolledLogoSrc = '{{ asset('images/Edtech-logo.png') }}';

        window.addEventListener('scroll', function () {
            if (window.scrollY > 0) {
                navbar.style.backgroundColor = 'white';
                navbar.style.color = 'black';

                navLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

          
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

 dropdown.forEach(function (link) {
                    link.style.color = 'black';
                });

 languageText.forEach(function (link) {
                    link.style.color = 'black';
                });

                logoImage.src = scrolledLogoSrc;
            } else {
                navbar.style.backgroundColor = 'black';
                navbar.style.color = 'white';
                navLinks.forEach(function (link) {
                    link.style.color = 'white';
                });

                // Change the text color of language menu items to white
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });
 dropdown.forEach(function (link) {
                    link.style.color = 'white';
                });
 languageText.forEach(function (link) {
                    link.style.color = 'white';
                });

                logoImage.src = initialLogoSrc;
            }
        });
    });

</script>

</body>
</html>