<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Exercise Content Creation</title>
    
  
    <link href="{{ asset('css/app.css') }}" rel="stylesheet"> 
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="preload" href="{{ asset('images/Contact 2.jpg') }}" as="image">
    <link rel="icon" href="{{ asset('images/favicon.png') }}" type="image/x-icon">
    <link href="{{ asset('css/Contact.css') }}" rel="stylesheet">

  
    <style>
        body {
            background-color: #f8f9fa;
            font-family: Arial, sans-serif;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            background-color: white;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .form-control, .form-control-file, select, textarea {
            width: 100%;
            padding: 0.5em;
            font-size: 1em;
            margin-bottom: 1em;
            box-sizing: border-box;
        }
        .exercise-wrapper {
            background-color: #f1f1f1;
            padding: 20px;
            border-radius: 5px;
            margin-bottom: 1rem;
            position: relative;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .remove-field {
            position: absolute;
            right: 10px; 
            top: 10px; 
            cursor: pointer;
            color: red;
            font-size: 1.5rem;
        }
        .option-input {
            display: flex;
            align-items: center;
            margin-bottom: 5px;
        }
        .option-input input[type="text"] {
            flex-grow: 1;
            margin-right: 10px;
        }
    </style>
</head>
<body>
 <div id="preloader">
        <div id="logo-container">
            <img src="{{ asset('images/Edtech-logo.png') }}" alt="Logo">
        </div>
    </div>
    
    <button id="back-to-top" style="display: none;" class="scroll-top-button">&#9650;</button>

    @include('Header')

    <div class="backgroundimage">
        <img src="{{ asset('images/Contact.jpg') }}" alt="Main Image">
    </div>

    <br><br><br>

    @if(session('success'))
        <div class="alert alert-success" style="text-align: center; margin-top: -40px; margin-left:750px; padding: 10px; background-color: #dff0d8; border-color: #d0e9c6; color: #3c763d;">
            {{ session('success') }}
        </div>
    @endif

    <div class="terms-text">
        <br><br>
        <h1>Practice at Class Content Form</h1>
        <br><br><br><br>
    </div>

    <div class="container mt-4">
      <form method="post" action="/practiceclassform" enctype="multipart/form-data">
    @csrf
            <div class="form-group">
                <label for="unitSelect">Select Unit</label>
                <select id="unitSelect" name="unit_id" class="form-control">
                    <option value="">Choose a Unit...</option>
                    @foreach($units as $unit)
                        <option value="{{ $unit->UnitID }}">{{ $unit->UnitTitle }}</option>
                    @endforeach
                </select>
            </div>
            
          
            <div id="exercise-fields">
                
            </div>
            
            <div class="btn-group">
                <button type="button" class="btn btn-primary" id="add-multiple-choice">Add Multiple Choice</button>
                <button type="button" class="btn btn-secondary" id="add-true-false">Add True/False</button>
                <button type="button" class="btn btn-success" id="add-fill-blank">Add Fill in the Blank</button>
                <button type="button" class="btn btn-info" id="add-essay">Add Essay</button>
                <button type="button" class="btn btn-dark" id="add-submit-form">Add Submit Form</button>
                <button type="button" class="btn btn-light" id="add-text-only">Add Text-Only</button>
                <button type="button" class="btn btn-light" id="add-image">Add an Image</button>

            </div>

            <input type="submit" class="btn btn-warning mt-3" value="Submit">
        </form>
    </div>

    @include('Footer')
    
       <script src="{{ asset('js/Contact.js') }}"></script>


<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.getElementById('add-multiple-choice').addEventListener('click', function() {
            addExerciseField('multiple-choice');
        });
        document.getElementById('add-true-false').addEventListener('click', function() {
            addExerciseField('true-false');
        });
        document.getElementById('add-fill-blank').addEventListener('click', function() {
            addExerciseField('fill-blank');
        });
        document.getElementById('add-essay').addEventListener('click', function() {
            addExerciseField('essay');
        });
        document.getElementById('add-submit-form').addEventListener('click', function() {
            addExerciseField('submit-form');
        });
        document.getElementById('add-text-only').addEventListener('click', function() {
            addExerciseField('text-only');
        });
        document.getElementById('add-image').addEventListener('click', function() {
                    addExerciseField('image');
        });
    });

    function addExerciseField(type) {
    let container = document.getElementById('exercise-fields');
    let fieldWrapper = document.createElement('div');
    fieldWrapper.classList.add('exercise-wrapper');
    
    let index = container.children.length;

    fieldWrapper.innerHTML += `
        <input type="hidden" name="exercise_types[${index}]" value="${type}">
        <label>Exercise Title:</label>
        <input type="text" name="exercise_titles[${index}]" class="form-control" placeholder="Enter Exercise Title">
    `;

        switch (type) {
            case 'multiple-choice':
                
                addMultipleChoiceField(fieldWrapper, index);
                break;
            case 'true-false':
                addTrueFalseField(fieldWrapper, index);
                break;
            case 'fill-blank':
                addFillBlankField(fieldWrapper, index);
                break;
            case 'essay':
                  addLongAnswerField(fieldWrapper, index, type);
                break;
            case 'submit-form':
                addLongAnswerField(fieldWrapper, index, type);
                break;
            case 'text-only':
    addTextOnlyField(fieldWrapper, index);
    break;
            case 'image':
                addImageField(fieldWrapper, index);
                break;

        }

        let removeButton = document.createElement('button');
        removeButton.innerHTML = '&times;'; // X sign
        removeButton.classList.add('remove-field', 'btn', 'btn-danger');
        removeButton.type = 'button';
        removeButton.onclick = function() { this.parentElement.remove(); };
        fieldWrapper.appendChild(removeButton);

        container.appendChild(fieldWrapper);
    }


 function addImageField(wrapper, index) {
        wrapper.innerHTML += `
            <label>Image Upload:</label>
            <input type="file" name="image_exercises[${index}]" class="form-control-file" accept="image/*">
        `;
    }
    
    
function addTextOnlyField(wrapper, index) {
    wrapper.innerHTML += `
        <label>Text-Only Exercise:</label>
        <textarea name="text_only_exercises[${index}]" class="form-control" style="width: 100%; height: 150px;" placeholder="Enter Text"></textarea>
    `;
}



function addMultipleChoiceField(wrapper, index) {
    wrapper.innerHTML += `
        <div id="multiple-choice-questions-${index}">
            <button type="button" onclick="addMultipleChoiceQuestion(${index})">Add Question</button>
        </div>
    `;
}

function addMultipleChoiceQuestion(exerciseIndex) {
    let questionsContainer = document.getElementById(`multiple-choice-questions-${exerciseIndex}`);
    let questionIndex = questionsContainer.children.length;

    let questionInput = document.createElement('div');
    questionInput.classList.add('question-input');
    questionInput.innerHTML = `
        <label>Question:</label>
        <input type="text" name="mc_questions[${exerciseIndex}][${questionIndex}]" class="form-control" placeholder="Enter question">
        <div id="mc_options-${exerciseIndex}-${questionIndex}">
            <button type="button" onclick="addMCOption(${exerciseIndex}, ${questionIndex})">Add Option</button>
        </div>
    `;
    questionsContainer.appendChild(questionInput);
}

function addMCOption(exerciseIndex, questionIndex) {
    let optionsContainer = document.getElementById(`mc_options-${exerciseIndex}-${questionIndex}`);
    let optionIndex = optionsContainer.getElementsByClassName('option-input').length;

    let optionLetter = String.fromCharCode(65 + optionIndex); 

    let optionInput = document.createElement('div');
    optionInput.classList.add('option-input');
    optionInput.innerHTML = `
        <input type="text" name="mc_options[${exerciseIndex}][${questionIndex}][]" class="form-control" value="${optionLetter}) ">
        <label>
            <input type="checkbox" name="mc_correct[${exerciseIndex}][${questionIndex}][]" value="${optionIndex}">
            Correct
        </label>
        <button type="button" class="remove-option" onclick="removeMCOption(this)">Remove</button>
    `;
    optionsContainer.insertBefore(optionInput, optionsContainer.children[optionsContainer.children.length - 1]);
}



function removeMCOption(button) {
    button.parentElement.remove();
}




 function addTrueFalseField(wrapper, index) {
    wrapper.innerHTML += `
    
        <div id="true-false-questions-${index}">
            <button type="button" onclick="addTrueFalseQuestion(${index})">Add Question</button>
        </div>
    `;
}

function addTrueFalseQuestion(exerciseIndex) {
    let questionsContainer = document.getElementById(`true-false-questions-${exerciseIndex}`);
    let questionIndex = questionsContainer.children.length - 1; 

    let questionInput = document.createElement('div');
    questionInput.classList.add('question-input');
    questionInput.innerHTML = `
        <label>Question:</label>
        <input type="text" name="tf_questions[${exerciseIndex}][${questionIndex}]" class="form-control" placeholder="Enter question">
        <select name="tf_answers[${exerciseIndex}][${questionIndex}]" class="form-control">
            <option value="true">True</option>
            <option value="false">False</option>
        </select>
        <button type="button" class="remove-question" onclick="removeTFQuestion(this)">Remove</button>
    `;
    questionsContainer.insertBefore(questionInput, questionsContainer.lastChild);
}

function removeTFQuestion(button) {
    button.parentElement.remove();
}



    function addFillBlankField(wrapper, index) {
        wrapper.innerHTML += `
            <div id="fill-blank-questions-${index}">
                <button type="button" onclick="addFillBlankQuestion(${index})">Add Question</button>
            </div>
        `;
    }

    function addFillBlankQuestion(exerciseIndex) {
        let questionsContainer = document.getElementById(`fill-blank-questions-${exerciseIndex}`);
        let questionIndex = questionsContainer.children.length;

        let questionInput = document.createElement('div');
        questionInput.classList.add('question-input');
        questionInput.innerHTML = `
            <label>Question (use '----' for blanks):</label>
            <input type="text" name="fb_questions[${exerciseIndex}][${questionIndex}]" class="form-control" placeholder="Enter question">
            <label>Answer:</label>
            <input type="text" name="fb_answers[${exerciseIndex}][${questionIndex}]" class="form-control" placeholder="Enter answer for blank">
        `;
        questionsContainer.appendChild(questionInput);
    }

    function addLongAnswerField(wrapper, index, type) {
    let fieldName = type === 'essay' ? 'essay_content' : 'submit_content';
    let questionType = type === 'essay' ? 'Essay' : 'Submit Form';
    wrapper.innerHTML += `
        <label>${questionType} Content:</label>
        <textarea name="${fieldName}[${index}]" class="form-control" style="width: 100%; height: 150px;" placeholder="Enter ${questionType.toLowerCase()} content"></textarea>
    `;
}


</script>




  <script>
        document.addEventListener('DOMContentLoaded', function () {
            var navbar = document.getElementById('navbar');
            var navLinks = document.querySelectorAll('.navbar a');
            var logoImage = document.getElementById('navbar-logo');
            var languageLinks = document.querySelectorAll('.dropdown-content a'); 
            var languageText = document.querySelectorAll('.selected-text');
            var hamburger = document.querySelectorAll('.hamburger');
            var dropdown = document.querySelectorAll('.dropdown-icon');

            var initialLogoSrc = '{{ asset('images/Edtech-logo-white-01-768x151-1.png') }}';
            var scrolledLogoSrc = '{{ asset('images/Edtech-logo.png') }}';

            window.addEventListener('scroll', function () {
                if (window.scrollY > 0) {
                    navbar.style.backgroundColor = 'white';
                    navbar.style.color = 'black';

                    navLinks.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    languageLinks.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    dropdown.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    languageText.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    logoImage.src = scrolledLogoSrc;
                } else {
                    navbar.style.backgroundColor = 'black';
                    navbar.style.color = 'white';
                    navLinks.forEach(function (link) {
                        link.style.color = 'white';
                    });

                    languageLinks.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    dropdown.forEach(function (link) {
                        link.style.color = 'white';
                    });

                    languageText.forEach(function (link) {
                        link.style.color = 'white';
                    });

                    logoImage.src = initialLogoSrc;
                }
            });
        });
    </script>
    
    
</body>
</html>