<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<link rel="preload" href="{{ asset('images/Contact 2.jpg') }}" as="image">
<link rel="icon" href="{{ asset('images/favicon.png') }}" type="image/x-icon">
<link href="{{ asset('css/Profile.css') }}" rel="stylesheet">

    <title>Profile</title>

  <style>

.courses-table-container {
    margin: auto;
    overflow-x: auto;
}

.courses-table {
    width: 100%;
    border-collapse: collapse;
}

.courses-table thead {
    background-color: #e9e9e9;
}

.courses-table th,
.courses-table td {
    text-align: left;
    padding: 8px;
    border: 1px solid #ddd;
}

.courses-table th {
    font-weight: bold;
}

.course-table-image {
    width: 50px;
    height: auto;
    margin-right: 10px;
    vertical-align: middle;
}

.course-link {
    color: black;
    text-decoration: none;
}

.course-link:hover {
    color: green;
    text-decoration: none;
}


.user-profile-container {
    display: flex;
    align-items: center;
    justify-content: start;
    background-color: #f5f5f5;
    border-radius: 10px;
    padding: 20px;
    margin: 20px auto;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    max-width: 1000px; 
}

.user-profile-container .profile-picture {
    flex-basis: 300px; 
    flex-shrink: 0;
    margin-right: 20px; 
    display: flex;
    justify-content: center;
    align-items: center;
}

.user-profile-container .profile-picture .profile-image {
    width: 300px; 
    height: 300px;
    border-radius: 50%;
    object-fit: cover;
    border: 5px solid #e9e9e9;
}



.profile-details {
    flex-grow: 1;
}

.username {
    font-size: 1.8em;
    color: #333;
    margin-bottom: 10px;
}

.profile-info {
    font-size: 1em;
    color: #666;
    margin: 5px 0;
}

.info-label {
    font-weight: bold;
    color: #333;
}


@media (max-width: 768px) {
    .user-profile-container {
        flex-direction: column;
        align-items: center;
        text-align: center;
        padding: 20px;
    }

    .profile-picture {
        margin-bottom: 20px;
        flex-basis: 
    }

    .profile-image {
        width: 180px;
        height: 180px;
    }

    .profile-details {
        flex-grow: 0;
    }
}



  </style>

</head>

<body>


<div id="preloader">
  <div id="logo-container">
  <img src="{{ asset('images/Edtech-logo.png') }}" alt="Logo">
  </div>
</div>

 <button id="back-to-top" style="display: none;" class="scroll-top-button">&#9650;</button>



 </div>
@include('Header')

    <div class="backgroundimage">
    <img src="{{ asset('images/Contact 2.jpg') }}" alt="Main Image">
    <br><br><br>
</div>
<div class="privacypolicy-text">
<h1>Profile</h1>
@if($user)
    <div class="user-profile">
    
   <div class="user-profile-container">
    <div class="profile-picture">
        <img src="{{ asset($user->ProfilePicture) }}" alt="User Profile Picture" class="profile-image">
    </div>
    <div class="profile-details">
        <h2 class="username">{{ $user->Username }}</h2>
        <p class="profile-info"><span class="info-label">First Name:</span> {{ $user->FirstName }}</p>
        <p class="profile-info"><span class="info-label">Last Name:</span> {{ $user->LastName }}</p>
        <p class="profile-info"><span class="info-label">Country:</span> {{ $user->Country }}</p>
    </div>
</div>


    </div>
@else
    <p>User not found!</p>
@endif

@if(isset($coursesInfo) && count($coursesInfo) > 0)
    <div class="courses-table-container">
        <table class="courses-table">
            <thead>
                <tr>
                    <th>Course Image</th>
                    <th>Name</th>
                    <th>Progress</th>
                    <th>Status</th>
                    <th>Start Date</th>
                    <th>Expiration time</th>
                </tr>
            </thead>
            <tbody>
                @foreach($coursesInfo as $course)
                    <tr>
                        <td>
                            <img src="{{ asset($course->CourseImage) }}" alt="Course Image" class="course-table-image">
                        </td>
                        <td>   <a href="{{ url('/coursedetails/' . $course->CourseID) }}" class="course-link">
    {{ $course->CourseName }}
</a>
</td>
                        <td>{{ $course->ProgressPercentage }}%</td>
                        <td>{{ $course->Status }}</td>
                        <td>{{ \Carbon\Carbon::parse($course->StartDate)->toFormattedDateString() }}</td>
                        <td>{{ $course->ExpiredDate ? \Carbon\Carbon::parse($course->ExpiredDate)->toFormattedDateString() : 'No expiration date' }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@else
    <p>No courses found!</p>
@endif



<br><br><br><br>





@include('Footer')


<script src="{{ asset('js/Courses.js') }}"></script>

<script>
 document.addEventListener('DOMContentLoaded', function () {
        var navbar = document.getElementById('navbar');
        var navLinks = document.querySelectorAll('.navbar a');
        var logoImage = document.getElementById('navbar-logo');
        var languageLinks = document.querySelectorAll('.dropdown-content a');
        var languageText = document.querySelectorAll('.selected-text');
  var hamburger = document.querySelectorAll('.hamburger');
  var dropdown = document.querySelectorAll('.dropdown-icon');

  var initialLogoSrc = '{{ asset('images/Edtech-logo-white-01-768x151-1.png') }}';
var scrolledLogoSrc = '{{ asset('images/Edtech-logo.png') }}';

        window.addEventListener('scroll', function () {
            if (window.scrollY > 0) {
                navbar.style.backgroundColor = 'white';
                navbar.style.color = 'black';

                navLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

          
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

 dropdown.forEach(function (link) {
                    link.style.color = 'black';
                });

 languageText.forEach(function (link) {
                    link.style.color = 'black';
                });

                logoImage.src = scrolledLogoSrc;
            } else {
                navbar.style.backgroundColor = 'black';
                navbar.style.color = 'white';
                navLinks.forEach(function (link) {
                    link.style.color = 'white';
                });

      
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });
 dropdown.forEach(function (link) {
                    link.style.color = 'white';
                });
 languageText.forEach(function (link) {
                    link.style.color = 'white';
                });

                logoImage.src = initialLogoSrc;
            }
        });
    });

</script>

</body>
</html>