<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Course Content Creation</title>
    

    <link href="{{ asset('css/app.css') }}" rel="stylesheet"> 
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="preload" href="{{ asset('images/Contact 2.jpg') }}" as="image">
    <link rel="icon" href="{{ asset('images/favicon.png') }}" type="image/x-icon">
    <link href="{{ asset('css/Contact.css') }}" rel="stylesheet">

 
   <style>
    body {
        background-color: #f8f9fa;
        font-family: Arial, sans-serif;
    }

    .container {
        max-width: 800px;
        margin: 0 auto;
        padding: 20px;
        background-color: white;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }

    .form-control, .form-control-file, select, textarea {
        width: 100%;
        padding: 0.5em;
        font-size: 1em;
        margin-bottom: 1em;
        box-sizing: border-box;
    }

   .field-wrapper {
            background-color: #f1f1f1;
            padding: 20px; 
            border-radius: 5px;
            margin-bottom: 1rem;
            position: relative;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

       
        .remove-field {
            position: absolute;
            right: 1px; 
            top: 1px; 
            cursor: pointer;
            color: red;
            font-size: 1.5rem;
            z-index: 0;
        }


      
    .form-control, .form-control-file, select, textarea {
        width: calc(100% - 20px); 
        padding: 0.5em;
        font-size: 1em;
        margin-bottom: 0.5em;
        box-sizing: border-box;
    }

    textarea.form-control {
        height: 150px; 
        resize: vertical; 
    }

    .text-style-options, .checkbox-group {
       
        display: flex;
        flex-wrap: wrap;
        gap: 5px;
        align-items: center;
        justify-content: flex-start;
    }

    .text-style-options > label, 
    .text-style-options > select {
        flex: 1 1 100%;
        margin-bottom: 5px; 
    }

    .checkbox-group label {
        margin-right: 10px; 
    }

    @media (max-width: 768px) {
      
        .text-style-options > label, 
        .text-style-options > select {
            width: 100%;
        }
    }
</style>


</head>

<body>
    <div id="preloader">
        <div id="logo-container">
            <img src="{{ asset('images/Edtech-logo.png') }}" alt="Logo">
        </div>
    </div>

    <button id="back-to-top" style="display: none;" class="scroll-top-button">&#9650;</button>

    @include('Header')

    <div class="backgroundimage">
        <img src="{{ asset('images/Contact.jpg') }}" alt="Main Image">
    </div>

    <br><br><br>

    @if(session('success'))
        <div class="alert alert-success" style="text-align: center; margin-top: -40px; margin-left:750px; padding: 10px; background-color: #dff0d8; border-color: #d0e9c6; color: #3c763d;">
            {{ session('success') }}
        </div>
    @endif

    <div class="terms-text">
        <br><br>
        <h1>Recording Content Form</h1>
        <br><br><br><br>
    </div>

    <div class="container mt-4">
     <form method="post" action="{{ route('storeRecording') }}" enctype="multipart/form-data">
    @csrf
            
             <div class="form-group">
            <label for="unitSelect">Select Unit</label>
           <select id="unitSelect" name="unit_id" class="form-control">
    <option value="">Choose a Unit...</option>
    @foreach($units as $unit)
        <option value="{{ $unit->UnitID }}">{{ $unit->UnitTitle }}</option>
    @endforeach
</select>

        </div>
        
            <div id="content-fields">
               
            </div>
            
            <div class="btn-group">
 
                <button type="button" class="btn btn-info" onclick="addField('video')">Add Video</button>
            </div>

            <input type="submit" class="btn btn-warning mt-3" value="Submit">
        </form>
    </div>

    @include('Footer')


    <script src="{{ asset('js/Contact.js') }}"></script>

   <script>
    // Function to add fields dynamically
   function addField(type) {
    let container = document.getElementById('content-fields');
    let fieldWrapper = document.createElement('div');
    fieldWrapper.classList.add('field-wrapper');

    if (type === 'video') {
        let fileInput = document.createElement('input');
        fileInput.setAttribute('type', 'file');
        fileInput.setAttribute('name', 'videos[]');
        fileInput.classList.add('form-control-file');
        fieldWrapper.appendChild(fileInput);
    }

    container.appendChild(fieldWrapper);
}


    
</script>




    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var navbar = document.getElementById('navbar');
            var navLinks = document.querySelectorAll('.navbar a');
            var logoImage = document.getElementById('navbar-logo');
            var languageLinks = document.querySelectorAll('.dropdown-content a'); 
            var languageText = document.querySelectorAll('.selected-text');
            var hamburger = document.querySelectorAll('.hamburger');
            var dropdown = document.querySelectorAll('.dropdown-icon');

            var initialLogoSrc = '{{ asset('images/Edtech-logo-white-01-768x151-1.png') }}';
            var scrolledLogoSrc = '{{ asset('images/Edtech-logo.png') }}';

            window.addEventListener('scroll', function () {
                if (window.scrollY > 0) {
                    navbar.style.backgroundColor = 'white';
                    navbar.style.color = 'black';

                    navLinks.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    languageLinks.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    dropdown.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    languageText.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    logoImage.src = scrolledLogoSrc;
                } else {
                    navbar.style.backgroundColor = 'black';
                    navbar.style.color = 'white';
                    navLinks.forEach(function (link) {
                        link.style.color = 'white';
                    });

                    languageLinks.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    dropdown.forEach(function (link) {
                        link.style.color = 'white';
                    });

                    languageText.forEach(function (link) {
                        link.style.color = 'white';
                    });

                    logoImage.src = initialLogoSrc;
                }
            });
        });
    </script>
</body>
</html>
