<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\ContactController;
use App\Http\Controllers\CoursesController;
use App\Http\Controllers\EventsController;
use App\Http\Controllers\HomeARController;
use App\Http\Controllers\HomeFRController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\OwnAFranchiseController;
use App\Http\Controllers\PrivacyPolicyController;
use App\Http\Controllers\RegisterController;
use App\Http\Controllers\TermsController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\CourseDetailsController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\CourseChapterController;
use App\Http\Controllers\LessonFormController;
use App\Http\Controllers\ExerciseFormController;
use App\Http\Controllers\RecordingFormController;
use App\Http\Controllers\PracticeHomeFormController;
use App\Http\Controllers\PracticeClassFormController;
use App\Http\Controllers\CourseLessonFormController;
use Illuminate\Support\Facades\DB;




/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [HomeController::class, 'showHome'])->name('home');

Route::get('/header', function () {
    return view('Header');
});


Route::get('/contact', [ContactController::class, 'showContact'])->name('contact');
Route::get('/courses', [CoursesController::class, 'showCourses'])->name('courses');
Route::get('/events', [EventsController::class, 'showEvents'])->name('events');
Route::get('/home/ar', [HomeARController::class, 'showHomeAR'])->name('homear');
Route::get('/home/fr', [HomeFRController::class, 'showHomeFR'])->name('homefr');
Route::get('/home', [HomeController::class, 'showHome'])->name('home');
Route::get('/login', [LoginController::class, 'showLogin'])->name('login');
Route::get('/ownafranchise', [OwnAFranchiseController::class, 'showOwnAFranchise'])->name('ownafranchise');
Route::get('/privacypolicy', [PrivacyPolicyController::class, 'showPrivacyPolicy'])->name('privacypolicy');
Route::get('/register', [RegisterController::class, 'showRegister'])->name('register');
Route::get('/terms', [TermsController::class, 'showTerms'])->name('terms');
Route::get('/logout', [LoginController::class, 'logout'])->name('logout');
Route::get('/profile', [ProfileController::class, 'showProfile'])->name('profile');

Route::get('/lessonform', [LessonFormController::class, 'showLessonForm'])->name('lessonform');

Route::post('/lessonform', [LessonFormController::class, 'storeLesson'])->name('storeLesson');


Route::get('/courselessonform', [CourseLessonFormController::class, 'showCourseLessonForm'])->name('courselessonform');

Route::get('/exerciseform', [ExerciseFormController::class, 'showExerciseForm'])->name('exerciseform');

Route::post('/exerciseform', [ExerciseFormController::class, 'storeExerciseForm'])->name('storeExerciseForm');

Route::get('/recordingform', [RecordingFormController::class, 'showRecordingForm'])->name('recordingform');

Route::post('/recordingform', [RecordingFormController::class, 'storeRecording'])->name('storeRecording');

Route::get('/practicehomeform', [PracticeHomeFormController::class, 'showPracticeHomeForm'])->name('practicehomeform');

Route::post('/practicehomeform', [PracticeHomeFormController::class, 'storePracticeHomeForm'])->name('storepracticehome');

Route::get('/practiceclassform', [PracticeClassFormController::class, 'showPracticeClassForm'])->name('practiceclassform');

Route::post('/practiceclassform', [PracticeClassFormController::class, 'storePracticeClassForm'])->name('storepracticeclass');



Route::get('/coursedetails/{courseId}', [CourseDetailsController::class, 'showCourseDetails'])
     ->name('coursedetails');

Route::get('/checkout', [CheckoutController::class, 'showCheckout'])
    ->middleware('auth')
    ->name('checkout');


Route::post('/checkout', [CheckoutController::class, 'handleCheckout'])->name('checkout.handle');

Route::get('/coursechapter/{courseId}',[CourseChapterController::class, 'showCourseChapter'])
     ->middleware('auth');


Route::get('/db-test', function() {
    try {
        DB::connection()->getPdo();
        return "Successfully connected to the database.";
    } catch (\Exception $e) {
        return "Failed to connect to the database. " . $e->getMessage();
    }
});

Route::get('/login', function () {
    if (auth()->check()) {
        return redirect('/home');
    }
    return view('Login');
})->name('login');

Route::get('/register', function () {
    if (auth()->check()) {
        return redirect('/home');
    }
    return view('Register');  
})->name('register');

Route::post('/login', [LoginController::class, 'login']);
Route::post('/register', [RegisterController::class, 'create']);



Route::post('/contact', [ContactController::class, 'storeMessage'])->name('store.message');
Route::post('/ownafranchise', [App\Http\Controllers\OwnAFranchiseController::class, 'store'])->name('ownafranchise.store');

