<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<link rel="preload" href="<?php echo e(asset('images/Contact 2.jpg')); ?>" as="image">
<link rel="icon" href="<?php echo e(asset('images/favicon.png')); ?>" type="image/x-icon">
<link href="<?php echo e(asset('css/Courses.css')); ?>" rel="stylesheet">

    <title>Checkout</title>

  
    <style>
   
    
        .billing-form {
            max-width: 600px;
            margin: 0 auto;
            background: #f7f7f7;
            padding: 20px;
            border-radius: 8px;
        }
        .billing-form h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .billing-form label {
            display: block;
            margin-bottom: 10px;
        }
        .billing-form input[type=text],
        .billing-form input[type=number] {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        .billing-form button {
            width: 100%;
            padding: 10px;
            border: none;
            border-radius: 4px;
            background-color: #5cb85c;
            color: white;
            cursor: pointer;
        }
        .billing-form button:hover {
            background-color: #4cae4c;
        }
        .payment-methods {
            margin-bottom: 20px;
        }
        .payment-methods input[type=radio] {
            margin-right: 10px;
        }
    </style>
</head>

<body>


<div id="preloader">
  <div id="logo-container">
  <img src="<?php echo e(asset('images/Edtech-logo.png')); ?>" alt="Logo">
  </div>
</div>

 <button id="back-to-top" style="display: none;" class="scroll-top-button">&#9650;</button>



 </div>
<?php echo $__env->make('Header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="backgroundimage">
    <img src="<?php echo e(asset('images/Contact 2.jpg')); ?>" alt="Main Image">
    <br><br><br>
</div>


<?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
<?php endif; ?>
<?php if(session('error')): ?>
    <div class="alert alert-danger">
        <?php echo e(session('error')); ?>

    </div>
<?php endif; ?>



<div class="privacypolicy-text">
    <h1><center>Checkout</center></h1>

<form method="POST" action="<?php echo e(route('checkout.handle')); ?>?courseId=<?php echo e($course->CourseID); ?>" id="checkoutForm">
    <?php echo csrf_field(); ?>
<div class="billing-form">
    <h2>Billing Information</h2>
    
    <label for="courseName">Course Name:</label>

    <h2><?php echo e($course->CourseName); ?></h2>
    <p>Price: US$<?php echo e($course->CoursePrice); ?></p>



        <div class="payment-methods">
            <p>Select Payment Method:</p>
            <label for="useCoupon">
                <input type="radio" id="useCoupon" name="paymentMethod" value="coupon">
                Use Coupon
            </label>
            <div id="couponCode" style="display: none;">
                <label for="couponInput">Coupon Code:</label>
                <input type="text" id="couponInput" name="couponCode" placeholder="Enter coupon code">
            </div>
            <label for="useVisaCard">
                <input type="radio" id="useVisaCard" name="paymentMethod" value="visa">
                Visa Card
            </label>
        </div>
        
        <button type="submit">Proceed to Payment</button>
    </div>
</form>

<br><br><br><br>




<?php echo $__env->make('Footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<script src="<?php echo e(asset('js/Courses.js')); ?>"></script>

<script>
 document.addEventListener('DOMContentLoaded', function () {
        var navbar = document.getElementById('navbar');
        var navLinks = document.querySelectorAll('.navbar a');
        var logoImage = document.getElementById('navbar-logo');
        var languageLinks = document.querySelectorAll('.dropdown-content a');
        var languageText = document.querySelectorAll('.selected-text');
  var hamburger = document.querySelectorAll('.hamburger');
  var dropdown = document.querySelectorAll('.dropdown-icon');

  var initialLogoSrc = '<?php echo e(asset('images/Edtech-logo-white-01-768x151-1.png')); ?>';
var scrolledLogoSrc = '<?php echo e(asset('images/Edtech-logo.png')); ?>';

        window.addEventListener('scroll', function () {
            if (window.scrollY > 0) {
                navbar.style.backgroundColor = 'white';
                navbar.style.color = 'black';

                navLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

          
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

 dropdown.forEach(function (link) {
                    link.style.color = 'black';
                });

 languageText.forEach(function (link) {
                    link.style.color = 'black';
                });

                logoImage.src = scrolledLogoSrc;
            } else {
                navbar.style.backgroundColor = 'black';
                navbar.style.color = 'white';
                navLinks.forEach(function (link) {
                    link.style.color = 'white';
                });

                // Change the text color of language menu items to white
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });
 dropdown.forEach(function (link) {
                    link.style.color = 'white';
                });
 languageText.forEach(function (link) {
                    link.style.color = 'white';
                });

                logoImage.src = initialLogoSrc;
            }
        });
    });

</script>


<script>
    document.addEventListener('DOMContentLoaded', function() {
        var radios = document.querySelectorAll('input[type=radio][name="paymentMethod"]');
        var submitButton = document.querySelector('.billing-form button'); // Get the button
        var previouslySelected; // To keep track of the previously selected radio button

        // Set default button text
        submitButton.textContent = 'Checkout';

        radios.forEach(function(radio) {
            radio.addEventListener('click', function(event) {
                var couponCode = document.getElementById('couponCode');
                // Check if the same radio button was clicked
                if(previouslySelected === event.target) {
                    // Deselect and reset form
                    previouslySelected = null;
                    event.target.checked = false;
                    couponCode.style.display = 'none';
                    submitButton.textContent = 'Checkout'; // Reset button text to default
                } else {
                    // Select new option and update button text
                    previouslySelected = event.target;
                    if(event.target.value === 'coupon') {
                        couponCode.style.display = 'block';
                        submitButton.textContent = 'Redeem'; // Change button text to Redeem
                    } else if(event.target.value === 'visa') {
                        couponCode.style.display = 'none';
                        submitButton.textContent = 'Proceed to Payment'; // Change button text to Proceed to Payment
                    }
                }
            });
        });
    });
</script>



</body>
</html><?php /**PATH /home1/edtechp4/public_html/edtechplusclub12102023/EdTechPlus/resources/views/Checkout.blade.php ENDPATH**/ ?>