<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<link rel="preload" href="<?php echo e(asset('images/Contact 2.jpg')); ?>" as="image">
<link rel="icon" href="<?php echo e(asset('images/favicon.png')); ?>" type="image/x-icon">
<link href="<?php echo e(asset('css/Register.css')); ?>" rel="stylesheet">


    <title>Register</title>

    
<style>
    textarea.has-error, input.has-error {
        border: 2px solid red !important;
    }

    .has-error + .error-message {
        color: red !important;
        font-size: 12px;
        margin-top: 5px;
    }
</style>

</head>

<body>


<div id="preloader">
  <div id="logo-container">
  <img src="<?php echo e(asset('images/Edtech-logo.png')); ?>" alt="Logo">
  </div>
</div>

 <button id="back-to-top" style="display: none;" class="scroll-top-button">&#9650;</button>

 <?php echo $__env->make('Header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <div class="backgroundimage">
    <img src="<?php echo e(asset('images/register page.jpg')); ?>" alt="Main Image">
</div>
<br><br><br><br><br><br>

<div class="login-container">
    <h1>Register</h1>


    <?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger">
        <?php echo e(session('error')); ?>

    </div>
<?php endif; ?>

    <form id="registration-form" enctype="multipart/form-data" action="<?php echo e(route('register')); ?>" method="POST">
      
    <?php echo csrf_field(); ?>

      <div class="form-group">
            <label for="first-name">First Name</label>
            <input type="text" id="first-name" name="first-name" value="<?php echo e(old('first-name')); ?>" required>
             <?php if($errors->has('first-name')): ?>
        <div class="error-message"><?php echo e($errors->first('first-name')); ?></div>
    <?php endif; ?>
        </div>
        <div class="form-group">
            <label for="last-name">Last Name</label>
            <input type="text" id="last-name" name="last-name" value="<?php echo e(old('last-name')); ?>" required>
             <?php if($errors->has('last-name')): ?>
        <div class="error-message"><?php echo e($errors->first('last-name')); ?></div>
    <?php endif; ?>
        </div>
        <div class="form-group">
            <label for="username">Username</label>
           <input type="text" id="username" name="username" value="<?php echo e($errors->first('username') == 'Username already exists' ? '' : old('username')); ?>" required>

             <?php if($errors->has('username')): ?>
        <div class="error-message"><?php echo e($errors->first('username')); ?></div>
    <?php endif; ?>
        </div>
        <div class="form-group">
            <label for="email">Email</label>
            <input type="email" id="email" name="email" value="<?php echo e(old('email')); ?>" required>
             <?php if($errors->has('email')): ?>
        <div class="error-message"><?php echo e($errors->first('email')); ?></div>
    <?php endif; ?>
        </div>
        <!-- <div class="form-group">
            <label for="confirm-email">Confirm Email</label>
            <input type="email" id="confirm-email" name="confirm-email" required>
        </div> -->
        <div class="form-group">
            <label for="password">Password</label>
            <input type="password" id="password" name="password" required>
             <?php if($errors->has('password')): ?>
        <div class="error-message"><?php echo e($errors->first('password')); ?></div>
    <?php endif; ?>
        </div>
        <!-- <div class="form-group">
            <label for="confirm-password">Confirm Password</label>
            <input type="password" id="confirm-password" name="confirm-password" required>
        </div> -->
        <div class="form-group">
            <label for="phone">Phone</label>
            <input type="tel" id="phone" name="phone" value="<?php echo e(old('phone')); ?>" required>
             <?php if($errors->has('phone')): ?>
        <div class="error-message"><?php echo e($errors->first('phone')); ?></div>
    <?php endif; ?>
        </div>
        <div class="form-group">
            <label for="city">City</label>
            <input type="text" id="city" name="city" value="<?php echo e(old('city')); ?>" required>
        </div>
        <div class="form-group">
            <label for="state">State</label>
            <input type="text" id="state" name="state" value="<?php echo e(old('state')); ?>" required>
        </div>
        <div class="form-group">
            <label for="address">Address</label>
            <input type="text" id="address" name="address" value="<?php echo e(old('address')); ?>" required>
        </div>
    
    <div class="form-group">
    <label for="country">Country</label>
    <select id="country" name="country" required 
        style="font-size: 20px; width: 300px; padding: 10px; border-radius: 5px;">

    <select name="country">
    <option value="Afghanistan" <?php echo e(old('country') == 'Afghanistan' ? 'selected' : ''); ?>>Afghanistan</option>
    <option value="Albania" <?php echo e(old('country') == 'Albania' ? 'selected' : ''); ?>>Albania</option>
    <option value="Algeria" <?php echo e(old('country') == 'Algeria' ? 'selected' : ''); ?>>Algeria</option>
    <option value="Andorra" <?php echo e(old('country') == 'Andorra' ? 'selected' : ''); ?>>Andorra</option>
    <option value="Angola" <?php echo e(old('country') == 'Angola' ? 'selected' : ''); ?>>Angola</option>
    <option value="Antigua and Barbuda" <?php echo e(old('country') == 'Antigua and Barbuda' ? 'selected' : ''); ?>>Antigua and Barbuda</option>
    <option value="Argentina" <?php echo e(old('country') == 'Argentina' ? 'selected' : ''); ?>>Argentina</option>
    <option value="Armenia" <?php echo e(old('country') == 'Armenia' ? 'selected' : ''); ?>>Armenia</option>
    <option value="Australia" <?php echo e(old('country') == 'Australia' ? 'selected' : ''); ?>>Australia</option>
    <option value="Austria" <?php echo e(old('country') == 'Austria' ? 'selected' : ''); ?>>Austria</option>
    <option value="Azerbaijan" <?php echo e(old('country') == 'Azerbaijan' ? 'selected' : ''); ?>>Azerbaijan</option>
    <option value="Bahamas" <?php echo e(old('country') == 'Bahamas' ? 'selected' : ''); ?>>Bahamas</option>
    <option value="Bahrain" <?php echo e(old('country') == 'Bahrain' ? 'selected' : ''); ?>>Bahrain</option>
    <option value="Bangladesh" <?php echo e(old('country') == 'Bangladesh' ? 'selected' : ''); ?>>Bangladesh</option>
    <option value="Barbados" <?php echo e(old('country') == 'Barbados' ? 'selected' : ''); ?>>Barbados</option>
    <option value="Belarus" <?php echo e(old('country') == 'Belarus' ? 'selected' : ''); ?>>Belarus</option>
    <option value="Belgium" <?php echo e(old('country') == 'Belgium' ? 'selected' : ''); ?>>Belgium</option>
    <option value="Belize" <?php echo e(old('country') == 'Belize' ? 'selected' : ''); ?>>Belize</option>
    <option value="Benin" <?php echo e(old('country') == 'Benin' ? 'selected' : ''); ?>>Benin</option>
    <option value="Bhutan" <?php echo e(old('country') == 'Bhutan' ? 'selected' : ''); ?>>Bhutan</option>
    <option value="Bolivia" <?php echo e(old('country') == 'Bolivia' ? 'selected' : ''); ?>>Bolivia</option>
    <option value="Bosnia and Herzegovina" <?php echo e(old('country') == 'Bosnia and Herzegovina' ? 'selected' : ''); ?>>Bosnia and Herzegovina</option>
    <option value="Botswana" <?php echo e(old('country') == 'Botswana' ? 'selected' : ''); ?>>Botswana</option>
    <option value="Brazil" <?php echo e(old('country') == 'Brazil' ? 'selected' : ''); ?>>Brazil</option>
    <option value="Brunei" <?php echo e(old('country') == 'Brunei' ? 'selected' : ''); ?>>Brunei</option>
    <option value="Bulgaria" <?php echo e(old('country') == 'Bulgaria' ? 'selected' : ''); ?>>Bulgaria</option>
    <option value="Burkina Faso" <?php echo e(old('country') == 'Burkina Faso' ? 'selected' : ''); ?>>Burkina Faso</option>
    <option value="Burundi" <?php echo e(old('country') == 'Burundi' ? 'selected' : ''); ?>>Burundi</option>
    <option value="Cabo Verde" <?php echo e(old('country') == 'Cabo Verde' ? 'selected' : ''); ?>>Cabo Verde</option>
    <option value="Cambodia" <?php echo e(old('country') == 'Cambodia' ? 'selected' : ''); ?>>Cambodia</option>
    <option value="Cameroon" <?php echo e(old('country') == 'Cameroon' ? 'selected' : ''); ?>>Cameroon</option>
    <option value="Canada" <?php echo e(old('country') == 'Canada' ? 'selected' : ''); ?>>Canada</option>
    <option value="Central African Republic" <?php echo e(old('country') == 'Central African Republic' ? 'selected' : ''); ?>>Central African Republic</option>
    <option value="Chad" <?php echo e(old('country') == 'Chad' ? 'selected' : ''); ?>>Chad</option>
    <option value="Chile" <?php echo e(old('country') == 'Chile' ? 'selected' : ''); ?>>Chile</option>
    <option value="China" <?php echo e(old('country') == 'China' ? 'selected' : ''); ?>>China</option>
    <option value="Colombia" <?php echo e(old('country') == 'Colombia' ? 'selected' : ''); ?>>Colombia</option>
    <option value="Comoros" <?php echo e(old('country') == 'Comoros' ? 'selected' : ''); ?>>Comoros</option>
    <option value="Congo, Democratic Republic of the" <?php echo e(old('country') == 'Congo, Democratic Republic of the' ? 'selected' : ''); ?>>Congo, Democratic Republic of the</option>
    <option value="Congo, Republic of the" <?php echo e(old('country') == 'Congo, Republic of the' ? 'selected' : ''); ?>>Congo, Republic of the</option>
    <option value="Costa Rica" <?php echo e(old('country') == 'Costa Rica' ? 'selected' : ''); ?>>Costa Rica</option>
    <option value="Côte d'Ivoire" <?php echo e(old('country') == "Côte d'Ivoire" ? 'selected' : ''); ?>>Côte d'Ivoire</option>
    <option value="Croatia" <?php echo e(old('country') == 'Croatia' ? 'selected' : ''); ?>>Croatia</option>
    <option value="Cuba" <?php echo e(old('country') == 'Cuba' ? 'selected' : ''); ?>>Cuba</option>
    <option value="Cyprus" <?php echo e(old('country') == 'Cyprus' ? 'selected' : ''); ?>>Cyprus</option>
    <option value="Czech Republic" <?php echo e(old('country') == 'Czech Republic' ? 'selected' : ''); ?>>Czech Republic</option>
    <option value="Denmark" <?php echo e(old('country') == 'Denmark' ? 'selected' : ''); ?>>Denmark</option>
    <option value="Djibouti" <?php echo e(old('country') == 'Djibouti' ? 'selected' : ''); ?>>Djibouti</option>
    <option value="Dominica" <?php echo e(old('country') == 'Dominica' ? 'selected' : ''); ?>>Dominica</option>
    <option value="Dominican Republic" <?php echo e(old('country') == 'Dominican Republic' ? 'selected' : ''); ?>>Dominican Republic</option>
    <option value="East Timor" <?php echo e(old('country') == 'East Timor' ? 'selected' : ''); ?>>East Timor</option>
    <option value="Ecuador" <?php echo e(old('country') == 'Ecuador' ? 'selected' : ''); ?>>Ecuador</option>
    <option value="Egypt" <?php echo e(old('country') == 'Egypt' ? 'selected' : ''); ?>>Egypt</option>
    <option value="El Salvador" <?php echo e(old('country') == 'El Salvador' ? 'selected' : ''); ?>>El Salvador</option>
    <option value="Equatorial Guinea" <?php echo e(old('country') == 'Equatorial Guinea' ? 'selected' : ''); ?>>Equatorial Guinea</option>
    <option value="Eritrea" <?php echo e(old('country') == 'Eritrea' ? 'selected' : ''); ?>>Eritrea</option>
    <option value="Estonia" <?php echo e(old('country') == 'Estonia' ? 'selected' : ''); ?>>Estonia</option>
    <option value="Eswatini" <?php echo e(old('country') == 'Eswatini' ? 'selected' : ''); ?>>Eswatini</option>
    <option value="Ethiopia" <?php echo e(old('country') == 'Ethiopia' ? 'selected' : ''); ?>>Ethiopia</option>
    <option value="Fiji" <?php echo e(old('country') == 'Fiji' ? 'selected' : ''); ?>>Fiji</option>
    <option value="Finland" <?php echo e(old('country') == 'Finland' ? 'selected' : ''); ?>>Finland</option>
    <option value="France" <?php echo e(old('country') == 'France' ? 'selected' : ''); ?>>France</option>
      <option value="Gabon" <?php echo e(old('country') == 'Gabon' ? 'selected' : ''); ?>>Gabon</option>
    <option value="Gambia" <?php echo e(old('country') == 'Gambia' ? 'selected' : ''); ?>>Gambia</option>
    <option value="Georgia" <?php echo e(old('country') == 'Georgia' ? 'selected' : ''); ?>>Georgia</option>
    <option value="Germany" <?php echo e(old('country') == 'Germany' ? 'selected' : ''); ?>>Germany</option>
    <option value="Ghana" <?php echo e(old('country') == 'Ghana' ? 'selected' : ''); ?>>Ghana</option>
    <option value="Greece" <?php echo e(old('country') == 'Greece' ? 'selected' : ''); ?>>Greece</option>
    <option value="Grenada" <?php echo e(old('country') == 'Grenada' ? 'selected' : ''); ?>>Grenada</option>
    <option value="Guatemala" <?php echo e(old('country') == 'Guatemala' ? 'selected' : ''); ?>>Guatemala</option>
    <option value="Guinea" <?php echo e(old('country') == 'Guinea' ? 'selected' : ''); ?>>Guinea</option>
    <option value="Guinea-Bissau" <?php echo e(old('country') == 'Guinea-Bissau' ? 'selected' : ''); ?>>Guinea-Bissau</option>
    <option value="Guyana" <?php echo e(old('country') == 'Guyana' ? 'selected' : ''); ?>>Guyana</option>
    <option value="Haiti" <?php echo e(old('country') == 'Haiti' ? 'selected' : ''); ?>>Haiti</option>
    <option value="Honduras" <?php echo e(old('country') == 'Honduras' ? 'selected' : ''); ?>>Honduras</option>
    <option value="Hungary" <?php echo e(old('country') == 'Hungary' ? 'selected' : ''); ?>>Hungary</option>
    <option value="Iceland" <?php echo e(old('country') == 'Iceland' ? 'selected' : ''); ?>>Iceland</option>
    <option value="India" <?php echo e(old('country') == 'India' ? 'selected' : ''); ?>>India</option>
    <option value="Indonesia" <?php echo e(old('country') == 'Indonesia' ? 'selected' : ''); ?>>Indonesia</option>
    <option value="Iran" <?php echo e(old('country') == 'Iran' ? 'selected' : ''); ?>>Iran</option>
    <option value="Iraq" <?php echo e(old('country') == 'Iraq' ? 'selected' : ''); ?>>Iraq</option>
    <option value="Ireland" <?php echo e(old('country') == 'Ireland' ? 'selected' : ''); ?>>Ireland</option>
    <option value="Israel" <?php echo e(old('country') == 'Israel' ? 'selected' : ''); ?>>Israel</option>
    <option value="Italy" <?php echo e(old('country') == 'Italy' ? 'selected' : ''); ?>>Italy</option>
    <option value="Jamaica" <?php echo e(old('country') == 'Jamaica' ? 'selected' : ''); ?>>Jamaica</option>
    <option value="Japan" <?php echo e(old('country') == 'Japan' ? 'selected' : ''); ?>>Japan</option>
    <option value="Jordan" <?php echo e(old('country') == 'Jordan' ? 'selected' : ''); ?>>Jordan</option>
    <option value="Kazakhstan" <?php echo e(old('country') == 'Kazakhstan' ? 'selected' : ''); ?>>Kazakhstan</option>
    <option value="Kenya" <?php echo e(old('country') == 'Kenya' ? 'selected' : ''); ?>>Kenya</option>
    <option value="Kiribati" <?php echo e(old('country') == 'Kiribati' ? 'selected' : ''); ?>>Kiribati</option>
    <option value="Korea, North" <?php echo e(old('country') == 'Korea, North' ? 'selected' : ''); ?>>Korea, North</option>
    <option value="Korea, South" <?php echo e(old('country') == 'Korea, South' ? 'selected' : ''); ?>>Korea, South</option>
    <option value="Kuwait" <?php echo e(old('country') == 'Kuwait' ? 'selected' : ''); ?>>Kuwait</option>
    <option value="Kyrgyzstan" <?php echo e(old('country') == 'Kyrgyzstan' ? 'selected' : ''); ?>>Kyrgyzstan</option>
    <option value="Laos" <?php echo e(old('country') == 'Laos' ? 'selected' : ''); ?>>Laos</option>
    <option value="Latvia" <?php echo e(old('country') == 'Latvia' ? 'selected' : ''); ?>>Latvia</option>
    <option value="Lebanon" <?php echo e(old('country') == 'Lebanon' ? 'selected' : ''); ?>>Lebanon</option>
    <option value="Lesotho" <?php echo e(old('country') == 'Lesotho' ? 'selected' : ''); ?>>Lesotho</option>
    <option value="Liberia" <?php echo e(old('country') == 'Liberia' ? 'selected' : ''); ?>>Liberia</option>
    <option value="Libya" <?php echo e(old('country') == 'Libya' ? 'selected' : ''); ?>>Libya</option>
    <option value="Liechtenstein" <?php echo e(old('country') == 'Liechtenstein' ? 'selected' : ''); ?>>Liechtenstein</option>
    <option value="Lithuania" <?php echo e(old('country') == 'Lithuania' ? 'selected' : ''); ?>>Lithuania</option>
    <option value="Luxembourg" <?php echo e(old('country') == 'Luxembourg' ? 'selected' : ''); ?>>Luxembourg</option>
    <option value="Madagascar" <?php echo e(old('country') == 'Madagascar' ? 'selected' : ''); ?>>Madagascar</option>
    <option value="Malawi" <?php echo e(old('country') == 'Malawi' ? 'selected' : ''); ?>>Malawi</option>
    <option value="Malaysia" <?php echo e(old('country') == 'Malaysia' ? 'selected' : ''); ?>>Malaysia</option>
    <option value="Maldives" <?php echo e(old('country') == 'Maldives' ? 'selected' : ''); ?>>Maldives</option>
    <option value="Mali" <?php echo e(old('country') == 'Mali' ? 'selected' : ''); ?>>Mali</option>
    <option value="Malta" <?php echo e(old('country') == 'Malta' ? 'selected' : ''); ?>>Malta</option>
    <option value="Marshall Islands" <?php echo e(old('country') == 'Marshall Islands' ? 'selected' : ''); ?>>Marshall Islands</option>
    <option value="Mauritania" <?php echo e(old('country') == 'Mauritania' ? 'selected' : ''); ?>>Mauritania</option>
    <option value="Mauritius" <?php echo e(old('country') == 'Mauritius' ? 'selected' : ''); ?>>Mauritius</option>
    <option value="Mexico" <?php echo e(old('country') == 'Mexico' ? 'selected' : ''); ?>>Mexico</option>
    <option value="Micronesia" <?php echo e(old('country') == 'Micronesia' ? 'selected' : ''); ?>>Micronesia</option>
    <option value="Moldova" <?php echo e(old('country') == 'Moldova' ? 'selected' : ''); ?>>Moldova</option>
    <option value="Monaco" <?php echo e(old('country') == 'Monaco' ? 'selected' : ''); ?>>Monaco</option>
    <option value="Mongolia" <?php echo e(old('country') == 'Mongolia' ? 'selected' : ''); ?>>Mongolia</option>
    <option value="Montenegro" <?php echo e(old('country') == 'Montenegro' ? 'selected' : ''); ?>>Montenegro</option>
    <option value="Morocco" <?php echo e(old('country') == 'Morocco' ? 'selected' : ''); ?>>Morocco</option>
    <option value="Mozambique" <?php echo e(old('country') == 'Mozambique' ? 'selected' : ''); ?>>Mozambique</option>
    <option value="Myanmar" <?php echo e(old('country') == 'Myanmar' ? 'selected' : ''); ?>>Myanmar</option>
    <option value="Namibia" <?php echo e(old('country') == 'Namibia' ? 'selected' : ''); ?>>Namibia</option>
    <option value="Nauru" <?php echo e(old('country') == 'Nauru' ? 'selected' : ''); ?>>Nauru</option>
    <option value="Nepal" <?php echo e(old('country') == 'Nepal' ? 'selected' : ''); ?>>Nepal</option>
    <option value="Netherlands" <?php echo e(old('country') == 'Netherlands' ? 'selected' : ''); ?>>Netherlands</option>
    <option value="New Zealand" <?php echo e(old('country') == 'New Zealand' ? 'selected' : ''); ?>>New Zealand</option>
    <option value="Nicaragua" <?php echo e(old('country') == 'Nicaragua' ? 'selected' : ''); ?>>Nicaragua</option>
<option value="Niger" <?php echo e(old('country') == 'Niger' ? 'selected' : ''); ?>>Niger</option>
<option value="Nigeria" <?php echo e(old('country') == 'Nigeria' ? 'selected' : ''); ?>>Nigeria</option>
<option value="North Macedonia" <?php echo e(old('country') == 'North Macedonia' ? 'selected' : ''); ?>>North Macedonia</option>
<option value="Norway" <?php echo e(old('country') == 'Norway' ? 'selected' : ''); ?>>Norway</option>
<option value="Oman" <?php echo e(old('country') == 'Oman' ? 'selected' : ''); ?>>Oman</option>
<option value="Pakistan" <?php echo e(old('country') == 'Pakistan' ? 'selected' : ''); ?>>Pakistan</option>
<option value="Palau" <?php echo e(old('country') == 'Palau' ? 'selected' : ''); ?>>Palau</option>
<option value="Palestine" <?php echo e(old('country') == 'Palestine' ? 'selected' : ''); ?>>Palestine</option>
<option value="Panama" <?php echo e(old('country') == 'Panama' ? 'selected' : ''); ?>>Panama</option>
<option value="Papua New Guinea" <?php echo e(old('country') == 'Papua New Guinea' ? 'selected' : ''); ?>>Papua New Guinea</option>
<option value="Paraguay" <?php echo e(old('country') == 'Paraguay' ? 'selected' : ''); ?>>Paraguay</option>
<option value="Peru" <?php echo e(old('country') == 'Peru' ? 'selected' : ''); ?>>Peru</option>
<option value="Philippines" <?php echo e(old('country') == 'Philippines' ? 'selected' : ''); ?>>Philippines</option>
<option value="Poland" <?php echo e(old('country') == 'Poland' ? 'selected' : ''); ?>>Poland</option>
<option value="Portugal" <?php echo e(old('country') == 'Portugal' ? 'selected' : ''); ?>>Portugal</option>
<option value="Qatar" <?php echo e(old('country') == 'Qatar' ? 'selected' : ''); ?>>Qatar</option>
<option value="Romania" <?php echo e(old('country') == 'Romania' ? 'selected' : ''); ?>>Romania</option>
<option value="Russia" <?php echo e(old('country') == 'Russia' ? 'selected' : ''); ?>>Russia</option>
<option value="Rwanda" <?php echo e(old('country') == 'Rwanda' ? 'selected' : ''); ?>>Rwanda</option>
<option value="Saint Kitts and Nevis" <?php echo e(old('country') == 'Saint Kitts and Nevis' ? 'selected' : ''); ?>>Saint Kitts and Nevis</option>
<option value="Saint Lucia" <?php echo e(old('country') == 'Saint Lucia' ? 'selected' : ''); ?>>Saint Lucia</option>
<option value="Saint Vincent and the Grenadines" <?php echo e(old('country') == 'Saint Vincent and the Grenadines' ? 'selected' : ''); ?>>Saint Vincent and the Grenadines</option>
<option value="Samoa" <?php echo e(old('country') == 'Samoa' ? 'selected' : ''); ?>>Samoa</option>
<option value="San Marino" <?php echo e(old('country') == 'San Marino' ? 'selected' : ''); ?>>San Marino</option>
<option value="Sao Tome and Principe" <?php echo e(old('country') == 'Sao Tome and Principe' ? 'selected' : ''); ?>>Sao Tome and Principe</option>
<option value="Saudi Arabia" <?php echo e(old('country') == 'Saudi Arabia' ? 'selected' : ''); ?>>Saudi Arabia</option>
<option value="Senegal" <?php echo e(old('country') == 'Senegal' ? 'selected' : ''); ?>>Senegal</option>
<option value="Serbia" <?php echo e(old('country') == 'Serbia' ? 'selected' : ''); ?>>Serbia</option>
<option value="Seychelles" <?php echo e(old('country') == 'Seychelles' ? 'selected' : ''); ?>>Seychelles</option>
<option value="Sierra Leone" <?php echo e(old('country') == 'Sierra Leone' ? 'selected' : ''); ?>>Sierra Leone</option>
<option value="Singapore" <?php echo e(old('country') == 'Singapore' ? 'selected' : ''); ?>>Singapore</option>
<option value="Slovakia" <?php echo e(old('country') == 'Slovakia' ? 'selected' : ''); ?>>Slovakia</option>
<option value="Slovenia" <?php echo e(old('country') == 'Slovenia' ? 'selected' : ''); ?>>Slovenia</option>
<option value="Solomon Islands" <?php echo e(old('country') == 'Solomon Islands' ? 'selected' : ''); ?>>Solomon Islands</option>
<option value="Somalia" <?php echo e(old('country') == 'Somalia' ? 'selected' : ''); ?>>Somalia</option>
<option value="South Africa" <?php echo e(old('country') == 'South Africa' ? 'selected' : ''); ?>>South Africa</option>
<option value="South Sudan" <?php echo e(old('country') == 'South Sudan' ? 'selected' : ''); ?>>South Sudan</option>
<option value="Spain" <?php echo e(old('country') == 'Spain' ? 'selected' : ''); ?>>Spain</option>
<option value="Sri Lanka" <?php echo e(old('country') == 'Sri Lanka' ? 'selected' : ''); ?>>Sri Lanka</option>
<option value="Sudan" <?php echo e(old('country') == 'Sudan' ? 'selected' : ''); ?>>Sudan</option>
<option value="Suriname" <?php echo e(old('country') == 'Suriname' ? 'selected' : ''); ?>>Suriname</option>
<option value="Sweden" <?php echo e(old('country') == 'Sweden' ? 'selected' : ''); ?>>Sweden</option>
<option value="Switzerland" <?php echo e(old('country') == 'Switzerland' ? 'selected' : ''); ?>>Switzerland</option>
<option value="Syria" <?php echo e(old('country') == 'Syria' ? 'selected' : ''); ?>>Syria</option>
<option value="Taiwan" <?php echo e(old('country') == 'Taiwan' ? 'selected' : ''); ?>>Taiwan</option>
<option value="Tajikistan" <?php echo e(old('country') == 'Tajikistan' ? 'selected' : ''); ?>>Tajikistan</option>
<option value="Tanzania" <?php echo e(old('country') == 'Tanzania' ? 'selected' : ''); ?>>Tanzania</option>
<option value="Thailand" <?php echo e(old('country') == 'Thailand' ? 'selected' : ''); ?>>Thailand</option>
<option value="Togo" <?php echo e(old('country') == 'Togo' ? 'selected' : ''); ?>>Togo</option>
<option value="Tonga" <?php echo e(old('country') == 'Tonga' ? 'selected' : ''); ?>>Tonga</option>
<option value="Trinidad and Tobago" <?php echo e(old('country') == 'Trinidad and Tobago' ? 'selected' : ''); ?>>Trinidad and Tobago</option>
<option value="Tunisia" <?php echo e(old('country') == 'Tunisia' ? 'selected' : ''); ?>>Tunisia</option>
<option value="Turkey" <?php echo e(old('country') == 'Turkey' ? 'selected' : ''); ?>>Turkey</option>
<option value="Turkmenistan" <?php echo e(old('country') == 'Turkmenistan' ? 'selected' : ''); ?>>Turkmenistan</option>
<option value="Tuvalu" <?php echo e(old('country') == 'Tuvalu' ? 'selected' : ''); ?>>Tuvalu</option>
<option value="Uganda" <?php echo e(old('country') == 'Uganda' ? 'selected' : ''); ?>>Uganda</option>
<option value="Ukraine" <?php echo e(old('country') == 'Ukraine' ? 'selected' : ''); ?>>Ukraine</option>
<option value="United Arab Emirates" <?php echo e(old('country') == 'United Arab Emirates' ? 'selected' : ''); ?>>United Arab Emirates</option>
<option value="United Kingdom" <?php echo e(old('country') == 'United Kingdom' ? 'selected' : ''); ?>>United Kingdom</option>
<option value="United States" <?php echo e(old('country') == 'United States' ? 'selected' : ''); ?>>United States</option>
<option value="Uruguay" <?php echo e(old('country') == 'Uruguay' ? 'selected' : ''); ?>>Uruguay</option>
<option value="Uzbekistan" <?php echo e(old('country') == 'Uzbekistan' ? 'selected' : ''); ?>>Uzbekistan</option>
<option value="Vanuatu" <?php echo e(old('country') == 'Vanuatu' ? 'selected' : ''); ?>>Vanuatu</option>
<option value="Vatican City" <?php echo e(old('country') == 'Vatican City' ? 'selected' : ''); ?>>Vatican City</option>

<option value="Venezuela" <?php echo e(old('country') == 'Venezuela' ? 'selected' : ''); ?>>Venezuela</option>
<option value="Vietnam" <?php echo e(old('country') == 'Vietnam' ? 'selected' : ''); ?>>Vietnam</option>
<option value="Yemen" <?php echo e(old('country') == 'Yemen' ? 'selected' : ''); ?>>Yemen</option>
<option value="Zambia" <?php echo e(old('country') == 'Zambia' ? 'selected' : ''); ?>>Zambia</option>
<option value="Zimbabwe" <?php echo e(old('country') == 'Zimbabwe' ? 'selected' : ''); ?>>Zimbabwe</option>
</select>
</div>

<div class="form-group">
    <label for="biography">Biography</label>
    <textarea id="biography" name="biography" class="<?php echo e($errors->has('biography') ? 'has-error' : ''); ?>" required><?php echo e(old('biography')); ?></textarea>
    <?php if($errors->has('biography')): ?>
        <span class="error-message"><?php echo e($errors->first('biography')); ?></span>
    <?php endif; ?>
</div>


  <div class="form-group">
    <label for="photoprofile">Profile Photo</label>
    <input type="file" id="photoprofile" name="photoprofile" accept="image/*" capture>
</div>
        <div class="form-group">
            <label for="photopassport">Passport Photo</label>
            <input type="file" id="photopassport" name="photopassport">
        </div>
        <div class="form-group">
            <label for="photoid">ID Photo</label>
            <input type="file" id="photoid" name="photoid">
        </div>
        <div class="form-group">
            <p>Already have an account? <a href="<?php echo e(route('login')); ?>">Login now</a></p>
        </div>
        <button type="submit">Register</button>
    </form>
</div>
<br><br><br>


</div>

<?php echo $__env->make('Footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<script src="<?php echo e(asset('js/Register.js')); ?>"></script>



<script>
 document.addEventListener('DOMContentLoaded', function () {
        var navbar = document.getElementById('navbar');
        var navLinks = document.querySelectorAll('.navbar a');
        var logoImage = document.getElementById('navbar-logo');
        var languageLinks = document.querySelectorAll('.dropdown-content a'); // Select language menu links
        var languageText = document.querySelectorAll('.selected-text');
  var hamburger = document.querySelectorAll('.hamburger');
  var dropdown = document.querySelectorAll('.dropdown-icon');


  var initialLogoSrc = '<?php echo e(asset('images/Edtech-logo-white-01-768x151-1.png')); ?>';
var scrolledLogoSrc = '<?php echo e(asset('images/Edtech-logo.png')); ?>';

        window.addEventListener('scroll', function () {
            if (window.scrollY > 0) {
                navbar.style.backgroundColor = 'white';
                navbar.style.color = 'black';

                navLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

                // Change the text color of language menu items to black
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

 dropdown.forEach(function (link) {
                    link.style.color = 'black';
                });

 languageText.forEach(function (link) {
                    link.style.color = 'black';
                });

                logoImage.src = scrolledLogoSrc;
            } else {
                navbar.style.backgroundColor = 'black';
                navbar.style.color = 'white';
                navLinks.forEach(function (link) {
                    link.style.color = 'white';
                });

                // Change the text color of language menu items to white
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });
 dropdown.forEach(function (link) {
                    link.style.color = 'white';
                });
 languageText.forEach(function (link) {
                    link.style.color = 'white';
                });

                logoImage.src = initialLogoSrc;
            }
        });
    });

</script>

</body>
</html><?php /**PATH /home2/edtechp4/public_html/edtechplusclub12102023/EdTechPlus/resources/views/Register.blade.php ENDPATH**/ ?>