<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<link rel="preload" href="<?php echo e(asset('images/Contact 2.jpg')); ?>" as="image">
<link rel="icon" href="<?php echo e(asset('images/favicon.png')); ?>" type="image/x-icon">
<link href="<?php echo e(asset('css/Login.css')); ?>" rel="stylesheet">

    <title>Login</title>

  

</head>

<body>


<div id="preloader">
  <div id="logo-container">
  <img src="<?php echo e(asset('images/Edtech-logo.png')); ?>" alt="Logo">
  </div>
</div>

 <button id="back-to-top" style="display: none;" class="scroll-top-button">&#9650;</button>



    <div class="toolbar-container">
        <header>
            <div class="left-links">
                <p class="small-text">Have any question?</p>
                <span class="icon">&#128222;</span>
                <a href="tel:+442034750264">+442034750264</a>
                <span class="icon">&#9993;</span>
                <a href="mailto:info@edtechplus.com">info@edtechplus.com</a>
            </div>
            <div class="right-links">
            <a href="<?php echo e(route('register')); ?>">Register</a>
                <a href="<?php echo e(route('login')); ?>">Login</a>


<a href="https://wa.me/447389775445" target="_blank" class="whatsapp-icon">
    <i class="fab fa-whatsapp"></i>
</a>

            </div>
        </header>
    </div>

    <div class="navbar" id="navbar">
       <div class="logo">
       <img src="<?php echo e(asset('images/Edtech-logo-white-01-768x151-1.png')); ?>" alt="Logo" id="navbar-logo">
       </div>

        <div class="right-links">
          <a href="<?php echo e(route('courses')); ?>" class="nav-link">COURSES</a>
            <a href="<?php echo e(route('ownafranchise')); ?>" class="nav-link">OWN A FRANCHISE</a>
            <a href="<?php echo e(route('home')); ?>" class="nav-link">HOME</a>
            <a href="<?php echo e(route('contact')); ?>" class="nav-link">CONTACT</a>
            <div class="dropdown">
        <button class="dropbtn">
            <span class="selected-icon">
                <img src="<?php echo e(asset('images/uk.png')); ?>" alt="English" class="flag">
            </span>
            <span class="selected-language"><div class="selected-text">ENGLISH</div></span>
            <div class="dropdown-icon"><i class="fa fa-caret-down"></i></div>
        </button>
        <ul class="dropdown-content">
            <li><a href="<?php echo e(route('homear')); ?>" class="flag">
            <img src="<?php echo e(asset('images/lebanon.jpg')); ?>" alt="Arabic" class="flag">
            <span class="selected-language">ARABIC</span></a></li>
            <li><a href="<?php echo e(route('home')); ?>" class="flag">
            <img src="<?php echo e(asset('images/uk.png')); ?>" alt="English" class="flag"> 

<span class="selected-language">ENGLISH</span></a></li>
            <li><a href="<?php echo e(route('homefr')); ?>" class="flag">
            <img src="<?php echo e(asset('images/france.png')); ?>" alt="French" class="flag">
            <span class="selected-language">FRANCAIS</span></a></li>
        </ul>
    </div>
            <span class="search-icon">&#128269;</span>
        </div>
    </div>

    <div class="backgroundimage">
<img src="<?php echo e(asset('images/Login Page 1.jpg')); ?>" alt="Main Image">
</div>
<br><br><br><br><br><br>

<div class="login-container">
    <h1>Login</h1>
    <form id="login-form">
        <div class="form-group">
            <label for="usernameOrEmail">Username or Email</label>
            <input type="text" id="usernameOrEmail" name="usernameOrEmail" required>
        </div>
        <div class="form-group">
            <label for="password">Password</label>
            <input type="password" id="password" name="password" required>
        </div>
        <div class="form-group">
            <a href="<?php echo e(route('login')); ?>">Forgot Password</a>
        </div>
        <div class="form-group">
            <p>Don't have an account? <a href="<?php echo e(route('register')); ?>">Register now</a></p>
        </div>
        <button type="submit">Login</button>
    </form>
</div>
<br>
<br>


<br><br><br>

<div class="footer">
    <div class="contact-info">
    <img src="<?php echo e(asset('images/Edtech-logo-white-01-768x151-1.png')); ?>" alt="Logo">
        <br>
        <span class="icon">&#128222; <a href="tel:+442034750264">+442034750264</a></span>
        <br>
        <span class="icon">&#9993; <a href="mailto:info@edtechplus.com">info@edtechplus.com</a></span>
        <br>
        <div class="social-icons">
            <!-- Add social media icons here -->
            <a href="https://www.facebook.com/edtechplusofficial" target="_blank" class="social-icon"><i class="fab fa-facebook"></i></a>
            <a href="https://www.linkedin.com/company/edtech-plus" target="_blank" class="social-icon"><i class="fab fa-linkedin"></i></a>
            <a href="https://www.instagram.com/Edtechplus/" target="_blank" class="social-icon"><i class="fab fa-instagram"></i></a>
        </div>
        <p>&copy; 2023 All Rights Reserved to EdTech Plus Ltd.</p>
    </div>
        <div class="footer-table">
        <table>
            <tr>
               
                <td>COMPANY</td>
                <td>LINKS</td>
                <td>SUPPORT</td>
                <td>PRIVACY</td>
            </tr>
            <tr>
               
                <td><a href="<?php echo e(route('ownafranchise')); ?>">Own a Franchise</a></td>
                <td><a href="<?php echo e(route('courses')); ?>">Courses</a><br><a 

href="<?php echo e(route('events')); ?>">Events</a></td>
                <td><a href="<?php echo e(route('contact')); ?>">Contact</a></td>
                <td><a href="<?php echo e(route('privacypolicy')); ?>">Privacy Policy</a> <br> 
<a href="<?php echo e(route('terms')); ?>">Terms</a></td>
            </tr>

        </table>
<div class="footer-policy">
    
        <a href="<?php echo e(route('terms')); ?>">Terms</a>
           <a href="<?php echo e(route('privacypolicy')); ?>">Privacy Policy</a>
    
 
    </div>
    </div>
</div>
    
</div>

<script src="<?php echo e(asset('js/Login.js')); ?>"></script>

<script>
 document.addEventListener('DOMContentLoaded', function () {
        var navbar = document.getElementById('navbar');
        var navLinks = document.querySelectorAll('.navbar a');
        var logoImage = document.getElementById('navbar-logo');
        var languageLinks = document.querySelectorAll('.dropdown-content a'); // Select language menu links
        var languageText = document.querySelectorAll('.selected-text');
  var hamburger = document.querySelectorAll('.hamburger');
  var dropdown = document.querySelectorAll('.dropdown-icon');


  var initialLogoSrc = '<?php echo e(asset('images/Edtech-logo-white-01-768x151-1.png')); ?>';
var scrolledLogoSrc = '<?php echo e(asset('images/Edtech-logo.png')); ?>';

        window.addEventListener('scroll', function () {
            if (window.scrollY > 0) {
                navbar.style.backgroundColor = 'white';
                navbar.style.color = 'black';

                navLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

                // Change the text color of language menu items to black
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

 dropdown.forEach(function (link) {
                    link.style.color = 'black';
                });

 languageText.forEach(function (link) {
                    link.style.color = 'black';
                });

                logoImage.src = scrolledLogoSrc;
            } else {
                navbar.style.backgroundColor = 'black';
                navbar.style.color = 'white';
                navLinks.forEach(function (link) {
                    link.style.color = 'white';
                });

                // Change the text color of language menu items to white
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });
 dropdown.forEach(function (link) {
                    link.style.color = 'white';
                });
 languageText.forEach(function (link) {
                    link.style.color = 'white';
                });

                logoImage.src = initialLogoSrc;
            }
        });
    });

</script>


</body>
</html><?php /**PATH C:\Users\PLC 6\Desktop\EdTechPlus\resources\views/Login.blade.php ENDPATH**/ ?>