<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<link rel="preload" href="<?php echo e(asset('images/Home Page Website.jpg')); ?>" as="image">
<link rel="icon" href="<?php echo e(asset('images/favicon.png')); ?>" type="image/x-icon">
<link href="<?php echo e(asset('css/Home FR.css')); ?>" rel="stylesheet">

    <title>EdTech Plus - Learning with a Difference</title>
    
</head>
<body>


<div id="preloader">
  <div id="logo-container">
  <img src="<?php echo e(asset('images/Edtech-logo.png')); ?>" alt="Logo">
  </div>
</div>

 <button id="back-to-top" style="display: none;" class="scroll-top-button">&#9650;</button>

 <?php echo $__env->make('HeaderFR', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

 
    <div class="backgroundimage">
    <img src="<?php echo e(asset('images/Home Page Website.jpg')); ?>" alt="Main Image">
</div>

    
    <div class="container">
        <div class="card">
            <img class="logo" src="<?php echo e(asset('images/edtech-plus-icons-02.webp')); ?>" alt="Card 1 Logo">
            <div>
                <h2>PARLEZ DU MONDE</h2>
                <p>avec nos cours de langues!</p>
                <a href="<?php echo e(route('courses')); ?>">VOIR LES COURS</a>
            </div>
        </div>
        
        <div class="card">
            <img class="logo" src="<?php echo e(asset('images/edtech-plus-icons-02.webp')); ?>" alt="Card 2 Logo">
            <div>
                <h2>CODEZ VOS REVES</h2>
                <p>avec nos cours de codage et de robotique!</p>
                <a href="<?php echo e(route('courses')); ?>">VOIR LES COURS</a>
            </div>
        </div>
    </div>
    <br><br>
    <div class="center-text">
        EdTech Plus Ltd : Elever l'education mondiale pour les dirigeants de demain.
    </div>
    <br><br><br>
<br>
    <table style="border-collapse: collapse;">
        <tr>
            <td class="left-column additional-text">
                EdTech Plus Ltd., dont le siege est a Londres, a lance sa marque mondiale " EdTech Plus " pour l'innovation et le developpement de l'education, mise en oeuvre dans plus de 21 pays.<br><br>
                
                Nous proposons une solution hybride complete qui ameliore l'apprentissage, permettant la pensee analytique et critique et offrant des experiences numeriques engageantes.

<br><br>
                
                
               EdTech Plus propose une large gamme de solutions EdTech innovantes dans divers sujets, notamment les langues, le codage, la robotique, la STEAM, l'impression 3D et bien plus encore. <br><br>
                
                
                EdTech Plus propose un package tout compris : materiel, logiciels, programme numerique de la maternelle a la 12e annee, plans de cours, cahiers d'exercices et formation des enseignants. <br><br>
                
                
               Au fond, nous nous efforcons de rendre les ecoles competentes en matiere de technologie, en nous comparant aux avant-gardes educatives mondiales.<br><br>
                
                
            S'appuyant sur 34 annees de prouesses pedagogiques, notre mission transcende les solutions conventionnelles de technologie educative. Nous croyons qu'il est important de transformer les etudiants en communicateurs mondiaux et en pionniers technologiques.<br><br>
                
                <b>Notre approche a deux volets :</b><br><br>
                

                <b>Apprentissage des langues EdTech Plus (maitrise linguistique):</b><br>
               En utilisant des reseaux neuronaux avances et des mecanismes adaptatifs, nous avons cree une arene d'apprentissage des langues de nouvelle generation. Nos cours, accredites par l'EdTech Plus Institute de Londres, couvrent l'anglais, l'espagnol, le francais et l'arabe.
Nous favorisons la maitrise du multilinguisme, ouvrant ainsi la voie aux etudiants qui souhaitent obtenir leur diplome en maitrisant plusieurs langues. Cette approche multilingue enrichit non seulement leur perspective mondiale, mais les encourage egalement en tant que communicateurs mondiaux.<br><br>
                

                <b>Autonomisation technologique EdTech Plus:</b><br>
                
           Nos programmes couvrent toute la gamme de sujets d'avenir, du codage, de la robotique, de la STEAM a l'impression 3D, placant nos etudiants en premiere ligne des innovations technologiques. Nos methodologies et outils de pointe propulsent les etudiants de la theorie aux innovations tangibles, en relevant les defis du monde reel.<br><br>
                

        Securite et acces inegales : nos plateformes numeriques, utilisables sur divers appareils, donnent la priorite a la securite des etudiants. Un protocole de securite strict garantit que nos apprenants sont proteges contre les contenus inappropries et les cybermenaces potentielles. Grace a un acces individualise, les etudiants peuvent explorer un tresor de ressources, en toute securite, a tout moment et en tout lieu.<br><br>
                

           Notre rayonnement : en partenariat avec plus de 500 etablissements d'enseignement reputes dans le monde, nos solutions sont finement adaptees et s'inspirent de diverses pratiques educatives. Notre equipe internationale dediee reste vigilante et s'aligne sur les dernieres innovations pedagogiques.<br><br>
                

              Dans un monde en constante evolution technologique, nous defendons la resilience et l'adaptabilite, preparant nos etudiants non seulement a s'adapter, mais aussi a diriger et innover. Rejoignez-nous dans ce voyage revolutionnaire, faconnant aujourd'hui les dirigeants de demain.
            </td>
            <td class="right-column">
                <div class="video-container">
                        <iframe width="560" height="315" src="https://www.youtube.com/embed/icFmABwbWMU" frameborder="0" allowfullscreen></iframe>         
                </div>
                <br>
            
            </td>
        </tr>
    </table>


             <td>
<div class="popular-courses">
    <h2><b>Cours populaires</b></h2>
</div>
</td>

     
<div class="scroll-container">
<table>

        <tr>
            <td class="coursescard">
                <a href="<?php echo e(route('courses')); ?>"
                    rel="bookmark">
                    <img src="<?php echo e(asset('images/Online-Linguaphone-Complete-English-4-scaled-1024x813-1.webp')); ?>"
                        alt="Course 1 Image" width="300">
                    <p>LINGUAPHONE UK</p>
                    <h2>Online Linguaphone
                        <br>Complete English  Fully Digital Course  All Levels (1,2,3,4,5,6,7,8,9)</h2>
                    <div class="numbers">
                        <span class="logo-paper">&#128196;</span> <!-- Paper icon -->
                        284 <!-- Number -->
                        <span class="logo-profile">&#128100;</span> <!-- Profile icon -->
                        19573298 <span class="price">$<b style="color: orange;">1,250.00</b></span> <!-- Price -->
                    </div>
                </a>
            </td>

            <!-- Repeat the same structure for other courses -->

            <td class="coursescard">
                <a href="<?php echo e(route('courses')); ?>"
                    rel="bookmark">
                    <img src="<?php echo e(asset('images/English-L1-scaled.webp')); ?>" alt="Course 2 Image" width="300">
                    <p>EdTech Plus</p>
                    <h2>EdTech Plus
                        <br>Complete English  Fully Digital Course  Level (1)</h2>
                    <div class="numbers">
                        <span class="logo-paper">&#128196;</span> <!-- Paper icon -->
                        22 <!-- Number -->
                        <span class="logo-profile">&#128100;</span> <!-- Profile icon -->
                       15786441 <span class="price">$<b style="color: orange;">400.00</b></span> <!-- Price -->
                    </div>
                </a>
            </td>

            <td class="coursescard">
                <a href="<?php echo e(route('courses')); ?>"
                    rel="bookmark">
                    <img src="<?php echo e(asset('images/English-cover.webp')); ?>" alt="Course 3 Image" width="300">
                    <p>EdTech Plus</p>
                    <h2>EdTech Plus
                        <br>Complete English  Fully Digital Course  All Levels (Foundation + 8 Levels)</h2>
                    <div class="numbers">
                        <span class="logo-paper">&#128196;</span> <!-- Paper icon -->
                        68 <!-- Number -->
                        <span class="logo-profile">&#128100;</span> <!-- Profile icon -->
                       15786430 <span class="price">$<b style="color: orange;">2,000.00</b></span> <!-- Price -->
                    </div>
                </a>
            </td>

            <td class="coursescard">
                <a href="<?php echo e(route('courses')); ?>"
                    rel="bookmark">
                    <img src="<?php echo e(asset('images/English-for-kids-L1-scaled.webp')); ?>" alt="Course 4 Image"
                        width="300">
                    <p>EdTech Plus</p>
                    <h2>EdTech Plus
                        <br>English for Kids  Fully Digital Course  Level (1)</h2>
                    <div class="numbers">
                        <span class="logo-paper">&#128196;</span> <!-- Paper icon -->
                        105 <!-- Number -->
                        <span class="logo-profile">&#128100;</span> <!-- Profile icon -->
                        498083 <span class="price"> $<b style="color: orange;">400.00</b></span> <!-- Price -->
                    </div>
                </a>
            </td>

 <td class="coursescard">
                <a href="<?php echo e(route('courses')); ?>"
                    rel="bookmark">
                    <img src="<?php echo e(asset('images/ENGLISH-FOR-KIDS-DESIGN-EDTECH-PLUS-LANGUAGES-0723.webp')); ?>" alt="Course 5 Image"
                        width="300">
                    <p>EdTech Plus</p>
                    <h2>EdTech Plus
                        <br>English for Kids  Fully Digital Course  All Levels (1, 2, 3)</h2>
                    <div class="numbers">
                        <span class="logo-paper">&#128196;</span> <!-- Paper icon -->
                        131 <!-- Number -->
                        <span class="logo-profile">&#128100;</span> <!-- Profile icon -->
                        498067 <span class="price"> $<b style="color: orange;">1,200.00</b></span> <!-- Price -->
                    </div>
                </a>
            </td>

 <td class="coursescard">
                <a href="<?php echo e(route('courses')); ?>"
                    rel="bookmark">
                    <img src="<?php echo e(asset('images/Spanish-L1-scaled.webp')); ?>" alt="Course 6 Image"
                        width="300">
                    <p>EdTech Plus</p>
                    <h2>EdTech Plus
                        <br>Complete Spanish  Fully Digital Course  Level (1)</h2>
                    <div class="numbers">
                        <span class="logo-paper">&#128196;</span> <!-- Paper icon -->
                        22 <!-- Number -->
                        <span class="logo-profile">&#128100;</span> <!-- Profile icon -->
                        213775 <span class="price"> $<b style="color: orange;">400.00</b></span> <!-- Price -->
                    </div>
                </a>
            </td>

        </tr>
    </table>
</div>

  <div class="events-container">
        <div class="events">
            <h1>Events: Upcoming Education Events to Feed Your Brain</h1>
            <div class="view-all">
                <a href="<?php echo e(route('events')); ?>">View All</a>
            </div>
            <div class="event">
                <div class="event-text">
                    <h2><a href="<?php echo e(route('events')); ?>">BETT SHOW UK 2020</a></h2>
                    <p class="date">23 October</p>
                    <p class="location">London</p>
                    <p>8:00 AM - 5:00 PM</p>
                    <p>You are cordially invited to visit our British sister company "Professional Learning Center LTD." at Bett Show UK 2020. Join us at our Stand...</p>
                </div>
                <img class="event-image" src="<?php echo e(asset('images/edtech-bett2-1-scaled-1.webp')); ?>" alt="Event 1 Image">
            </div>
            <div class="event">
                <div class="event-text">
                    <h2><a href="<?php echo e(route('events')); ?>">HIGH-LEVEL LEBANON-UK TECH FORUM</a></h2>
                    <p class="date">15 March</p>
                    <p class="location">London</p>
                    <p>12:00 AM - 5:00 PM</p>
                    <p>PLC- Professional Learning Center is honored to be the only Lebanese institute mentioned in the closing speech of the British Ambassador to Lebanon HMA...</p>
                </div>
                <img class="event-image" src="<?php echo e(asset('images/tech-forum.webp')); ?>" alt="Event 2 Image">
            </div>
            <!-- Add more events here if needed -->
        </div>
    </div>
<br>
<br>
<br>



</div>

<?php echo $__env->make('Footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



<script src="<?php echo e(asset('js/Home FR.js')); ?>"></script>


<script>
 document.addEventListener('DOMContentLoaded', function () {
        var navbar = document.getElementById('navbar');
        var navLinks = document.querySelectorAll('.navbar a');
        var logoImage = document.getElementById('navbar-logo');
        var languageLinks = document.querySelectorAll('.dropdown-content a'); // Select language menu links
        var languageText = document.querySelectorAll('.selected-text');
  var hamburger = document.querySelectorAll('.hamburger');
  var dropdown = document.querySelectorAll('.dropdown-icon');


  var initialLogoSrc = '<?php echo e(asset('images/Edtech-logo-white-01-768x151-1.png')); ?>';
var scrolledLogoSrc = '<?php echo e(asset('images/Edtech-logo.png')); ?>';

        window.addEventListener('scroll', function () {
            if (window.scrollY > 0) {
                navbar.style.backgroundColor = 'white';
                navbar.style.color = 'black';

                navLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

                // Change the text color of language menu items to black
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

 dropdown.forEach(function (link) {
                    link.style.color = 'black';
                });

 languageText.forEach(function (link) {
                    link.style.color = 'black';
                });

                logoImage.src = scrolledLogoSrc;
            } else {
                navbar.style.backgroundColor = 'black';
                navbar.style.color = 'white';
                navLinks.forEach(function (link) {
                    link.style.color = 'white';
                });

                // Change the text color of language menu items to white
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });
 dropdown.forEach(function (link) {
                    link.style.color = 'white';
                });
 languageText.forEach(function (link) {
                    link.style.color = 'white';
                });

                logoImage.src = initialLogoSrc;
            }
        });
    });

</script>


</body>
</html><?php /**PATH /home1/edtechp4/public_html/edtechplusclub12102023/EdTechPlus/resources/views/Home FR.blade.php ENDPATH**/ ?>