<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<link rel="preload" href="<?php echo e(asset('images/Contact 2.jpg')); ?>" as="image">
<link rel="icon" href="<?php echo e(asset('images/favicon.png')); ?>" type="image/x-icon">
<link href="<?php echo e(asset('css/CourseDetails.css')); ?>" rel="stylesheet">

    <title>Course Details</title>

  <style>

.title-and-button {
  display: flex;
  justify-content: flex-start;
  align-items: center;
  gap: 10px;
}

.price-and-button-container {
    display: flex;
    justify-content: flex-end; 
    align-items: center;
    gap: 10px;
}

.course-price {
    font-size: 2rem;
    color: red;
    font-weight: bold;
}

.buy-button {
    background-color: #90EE90;
    color: white;
    border: none;
    padding: 15px 30px;
    font-size: 1rem;
    cursor: pointer;
    border-radius: 5px;
}

.course-detail-container h1 {
    margin-bottom: 0.5em; 
    font-size: 2rem; 
    font-weight: 
}


  </style>

</head>

<body>


<div id="preloader">
  <div id="logo-container">
  <img src="<?php echo e(asset('images/Edtech-logo.png')); ?>" alt="Logo">
  </div>
</div>

 <button id="back-to-top" style="display: none;" class="scroll-top-button">&#9650;</button>



 </div>
<?php echo $__env->make('Header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="backgroundimage">
    <img src="<?php echo e(asset('images/Contact 2.jpg')); ?>" alt="Main Image">
    <br><br><br>
</div>
<div class="privacypolicy-text">

   <h1><?php echo e($course->CourseName); ?></h1>
   <div class="price-and-button-container">
    <span class="course-price">Price: US$<?php echo e($course->CoursePrice); ?></span>
    <?php if($userEnrolled): ?>
     
     <button class="buy-button" onclick="window.location.href='<?php echo e(url('/coursechapter/' . $course->CourseID)); ?>'">Continue</button>

<?php else: ?>
    <button class="buy-button" onclick="window.location.href='<?php echo e(route('checkout')); ?>?courseId=<?php echo e($course->CourseID); ?>'">Buy</button>
<?php endif; ?>

</div>


  
    <img src="<?php echo e(asset($course->CourseImage)); ?>" alt="<?php echo e($course->CourseName); ?> Image" width="300">
    <p>Author: <?php echo e($course->CourseAuthor); ?></p>
    <p>Description: <?php echo e($course->CourseDescription); ?></p>
    <p>Duration: <?php echo e($course->CourseDuration); ?></p>
    <p><?php echo e($course->CourseCertificate ? 'Certificate Available' : 'No Certificate'); ?></p>
  
</div>


<br><br><br><br>




<?php echo $__env->make('Footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<script src="<?php echo e(asset('js/CourseDetails.js')); ?>"></script>

<script>
 document.addEventListener('DOMContentLoaded', function () {
        var navbar = document.getElementById('navbar');
        var navLinks = document.querySelectorAll('.navbar a');
        var logoImage = document.getElementById('navbar-logo');
        var languageLinks = document.querySelectorAll('.dropdown-content a');
        var languageText = document.querySelectorAll('.selected-text');
  var hamburger = document.querySelectorAll('.hamburger');
  var dropdown = document.querySelectorAll('.dropdown-icon');

  var initialLogoSrc = '<?php echo e(asset('images/Edtech-logo-white-01-768x151-1.png')); ?>';
var scrolledLogoSrc = '<?php echo e(asset('images/Edtech-logo.png')); ?>';

        window.addEventListener('scroll', function () {
            if (window.scrollY > 0) {
                navbar.style.backgroundColor = 'white';
                navbar.style.color = 'black';

                navLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

          
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

 dropdown.forEach(function (link) {
                    link.style.color = 'black';
                });

 languageText.forEach(function (link) {
                    link.style.color = 'black';
                });

                logoImage.src = scrolledLogoSrc;
            } else {
                navbar.style.backgroundColor = 'black';
                navbar.style.color = 'white';
                navLinks.forEach(function (link) {
                    link.style.color = 'white';
                });

   
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });
 dropdown.forEach(function (link) {
                    link.style.color = 'white';
                });
 languageText.forEach(function (link) {
                    link.style.color = 'white';
                });

                logoImage.src = initialLogoSrc;
            }
        });
    });

</script>

</body>
</html><?php /**PATH /home1/edtechp4/public_html/edtechplusclub12102023/EdTechPlus/resources/views/CourseDetails.blade.php ENDPATH**/ ?>