<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<link rel="preload" href="<?php echo e(asset('images/Contact 2.jpg')); ?>" as="image">
<link rel="icon" href="<?php echo e(asset('images/favicon.png')); ?>" type="image/x-icon">
<link href="<?php echo e(asset('css/CourseDetails.css')); ?>" rel="stylesheet">

    <title>Course Chapter</title>

 <style>
 .buttonResult {
    background-color: #4CAF50; 
    border: none;
    color: white;
    padding: 15px 32px;
    text-align: center;
    text-decoration: none;
    display: inline-block;
    font-size: 16px;
    margin: 4px 2px;
    cursor: pointer;
}

 
  .exercise-title {
        font-size: 35px;
        font-weight: bold;
        text-decoration: underline;
    }
    .exercise-question {
        font-size: 25px;
        font-weight: bold;
    }
    .exercise-option {
        font-size: 15px;
        margin-left: 20px;
    }
    .exercise-section {
        display: none;
    }
    
    
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        .title-and-button {
            display: flex;
            justify-content: flex-start;
            align-items: center;
            gap: 10px;
        }

        .price-and-button-container {
            display: flex;
            justify-content: flex-end; 
            align-items: center;
            gap: 10px;
        }

        .course-price {
            font-size: 2rem;
            color: red;
            font-weight: bold;
        }

        .buy-button {
            background-color: #90EE90;
            color: white;
            border: none;
            padding: 15px 30px;
            font-size: 1rem;
            cursor: pointer;
            border-radius: 5px;
        }

        .course-detail-container h1 {
            margin-bottom: 0.5em; 
            font-size: 2rem;
            font-weight: bold;
        }

        .container {
            display: flex;
            max-width: 1600px;
            margin: 0 auto;
        }

        .chapter-sidebar {
            width: 200px;
            margin-top: 60px; 
        }

        .chapter-content {
            flex-grow: 1;
            margin-left: 20px; 
            margin-top: 60px;
        }

        .chapter-list {
            list-style-type: none;
            padding: 0;
            margin: 0;
        }

        .chapter-item + .chapter-item {
            margin-top: 15px;
        }

        .chapter-link {
            display: block;
            padding: 10px;
            background-color: #e9ecef;
            color: #333;
            text-decoration: none;
            font-weight: bold;
        }

        .chapter-link:hover,
        .chapter-link:focus {
            background-color: #dee2e6;
        }

        .subchapter-list {
            list-style-type: none;
            padding: 0;
            padding-left: 20px;
        }

        .subchapter-list li a {
            display: block;
            padding: 5px 10px;
            text-decoration: none;
            color: #555;
        }

        .subchapter-list li a:hover,
        .subchapter-list li a:focus {
            background-color: #e2e6ea;
        }

        .hidden {
            display: none;
        }

        .lesson-images {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-top: 20px;
        }

        .lesson-images img {
            margin-bottom: 10px;
        }

        
        .main-content {
            display: flex;
        }

        .left-menu {
            width: 200px;
            position: fixed;
            left: 0;
            top: 0;
            bottom: 0;
            background-color: #f8f9fa; 
            padding: 20px;
            overflow-y: auto; 
        }

        .content-area {
            margin-left: 220px;
            padding: 20px;
        }

      
        @media screen and (max-width: 768px) {
            .left-menu {
                position: static;
                width: auto;
                height: auto;
            }
            .content-area {
                margin-left: 0;
            }
        }
        
        .lesson-title {
    font-size: 35px;      
    font-weight: bold;   

}
.correct-answer {
    color: green;
}

.incorrect-answer {
    color: red;
}
.video-container {
    margin-top: 20px; 
    text-align: center; 
}

video {
    max-width: 100%;  
    height: auto; 
}


    </style>

</head>

<body>
    <div id="preloader">
        <div id="logo-container">
            <img src="<?php echo e(asset('images/Edtech-logo.png')); ?>" alt="Logo">
        </div>
    </div>

    <button id="back-to-top" style="display: none;" class="scroll-top-button">&#9650;</button>

    <?php echo $__env->make('Header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="backgroundimage">
        <img src="<?php echo e(asset('images/Contact 2.jpg')); ?>" alt="Main Image">
    </div>

  <!--
<div class="privacypolicy-text">
    <h1>Welcome, <?php echo e($user->Username); ?></h1>
    </div> -->
    <div class="privacypolicy-text">
    <h2><?php echo e($course->CourseName); ?></h2>
</div>


    <div class="container">
        <table style="width: 100%; border: none;" border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td style="vertical-align: top; border: none;">
                    <div class="chapter-sidebar">
            <ul class="chapter-list">
                <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="chapter-item">
                        <strong>Unit <?php echo e($unit->UnitNumber); ?></strong>
                        <ul class="subchapter-list">
                               <a href="<?php echo e(route('showCourseChapter', ['courseChapterId' => 8, 'unitId' => 1])); ?>">
    Open Lesson
</a>

                            
                         <li><a href="javascript:void(0);" onclick="showExercises(<?php echo e($unit->UnitID); ?>, <?php echo e($unit->UnitNumber); ?>, <?php echo e(json_encode($unit->exercises)); ?>)">Exercise</a></li>

        
 <li>Recording Session</li>
 
                           <!--<li><a href="javascript:void(0);" onclick="showRecording(<?php echo e($unit->UnitID); ?>)">Recording Session</a></li>-->
       
                           <li>
    <a href="javascript:void(0);" onclick="showPracticeInClass(<?php echo e($unit->UnitID); ?>, <?php echo e($unit->UnitNumber); ?>, <?php echo e(json_encode($unit->practicesInClass)); ?>)">
        Practice in Class
    </a>
</li>

                           <li>
    <a href="javascript:void(0);" onclick="showPracticeAtHome(<?php echo e($unit->UnitID); ?>, <?php echo e($unit->UnitNumber); ?>, <?php echo e(json_encode($unit->practicesAtHome)); ?>)">
        Practice at Home
    </a>
</li>

                            
                       
                        </ul>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>

                </td>
                <td style="vertical-align: top; border: none;">
                    <div class="chapter-content">
          <div class="chapter-content">
            <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <section id="unit<?php echo e($unit->UnitID); ?>" class="lesson-section">
                  <h4 class="lesson-title">Lesson for Unit <?php echo e($unit->UnitNumber); ?></h4>

                    <?php $__currentLoopData = $unit->lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $lesson->content; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contentItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php switch($contentItem['type']):
                                case ('title'): ?>
                                    <h2 style="font-size: <?php echo e($contentItem['size']); ?>px; color: <?php echo e($contentItem['color']); ?>; font-weight: <?php echo e($contentItem['bold'] ? 'bold' : 'normal'); ?>; font-style: <?php echo e($contentItem['italic'] ? 'italic' : 'normal'); ?>; text-decoration: <?php echo e($contentItem['underline'] ? 'underline' : 'none'); ?>;">
                                        <?php echo nl2br(e($contentItem['content'])); ?>

                                    </h2>
                                    <?php break; ?>
                                <?php case ('text'): ?>
                                    <p style="font-size: <?php echo e($contentItem['size']); ?>px; color: <?php echo e($contentItem['color']); ?>; font-weight: <?php echo e($contentItem['bold'] ? 'bold' : 'normal'); ?>; font-style: <?php echo e($contentItem['italic'] ? 'italic' : 'normal'); ?>; text-decoration: <?php echo e($contentItem['underline'] ? 'underline' : 'none'); ?>;">
                                        <?php echo nl2br(e($contentItem['content'])); ?>

                                    </p>
                                    <?php break; ?>
                                <?php case ('image'): ?>
                                     <img src="<?php echo e(asset($contentItem['content'])); ?>" alt="Image" style="max-width: 100%;">
               
                                    <?php break; ?>
                                <?php case ('video'): ?>
                                    <div class="video-container">
                                        <iframe src="<?php echo e($contentItem['content']); ?>" frameborder="0" allowfullscreen></iframe>
                                    </div>
                                    <?php break; ?>
                                <?php default: ?>
                                    <p>Unknown content type.</p>
                            <?php endswitch; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </section>
                
               <section id="exercises<?php echo e($unit->UnitID); ?>" class="exercise-section" style="display: none;">
                   
           
 
            <?php $__currentLoopData = $unit->exercises; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exercise): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div>
                
                
                
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </section>
        
        <section id="practiceInClass<?php echo e($unit->UnitID); ?>" class="exercise-section" style="display: none;">
    <?php $__currentLoopData = $unit->practicesInClass; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $practice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div>
         
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</section>

 <section id="practiceAtHome<?php echo e($unit->UnitID); ?>" class="exercise-section" style="display: none;">
    <?php $__currentLoopData = $unit->practicesAtHome; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $practicehome): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div>
         
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
</section>

        
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
            </tr>
        </table>
    </div>

    <?php echo $__env->make('Footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<script src="<?php echo e(asset('js/CourseDetails.js')); ?>"></script>

<script>

function showPracticeAtHome(unitID, unitNumber, practicesAtHome) {
    var lessonSections = document.querySelectorAll('.lesson-section');
    var practiceSections = document.querySelectorAll('.exercise-section');
    lessonSections.forEach(section => section.style.display = 'none');
    practiceSections.forEach(section => section.style.display = 'none');

    var practiceContainer = document.createElement('div');
    var practicesTitle = document.createElement('h2');
    practicesTitle.style.fontSize = '35px';
    practicesTitle.style.fontWeight = 'bold';
    practicesTitle.innerHTML = 'Practice at Home for Unit ' + unitNumber;
    practiceContainer.appendChild(practicesTitle);

    practicesAtHome.forEach(practice => {
        var practiceContent;
        if (typeof practice.content === 'string') {
            practiceContent = JSON.parse(practice.content); 
        } else if (practice.content) {
            practiceContent = practice.content; 
        } else {
            console.error('Invalid practice format', practice);
            return;
        }

     
        practiceContent.forEach(item => {
            if (item.type === 'text-only') {
                var itemTitleEl = document.createElement('h3');
                itemTitleEl.style.fontSize = '25px';
                itemTitleEl.style.fontWeight = 'bold';
                itemTitleEl.style.textDecoration = 'underline';
                itemTitleEl.innerHTML = item.title; 
                practiceContainer.appendChild(itemTitleEl);

                var textContentEl = document.createElement('p');
                textContentEl.style.fontSize = '20px';
                 textContentEl.innerHTML = item.content
            .replace(/(?:\r\n|\r|\n)/g, '<br>')  
            .replace(/<br>\s*•/g, '<br>&emsp;•'); 

                practiceContainer.appendChild(textContentEl);
            }
          
        });
    });

    var selectedPracticeSection = document.getElementById('practiceAtHome' + unitID);
    if (selectedPracticeSection) {
        selectedPracticeSection.innerHTML = '';
        selectedPracticeSection.appendChild(practiceContainer);
        selectedPracticeSection.style.display = 'block';
    }
}




function showPracticeInClass(unitID, unitNumber, practicesInClass) {
    var lessonSections = document.querySelectorAll('.lesson-section');
    var practiceSections = document.querySelectorAll('.exercise-section');
    lessonSections.forEach(section => section.style.display = 'none');
    practiceSections.forEach(section => section.style.display = 'none');

    var practiceContainer = document.createElement('div');
    var practicesTitle = document.createElement('h2');
    practicesTitle.style.fontSize = '35px';
    practicesTitle.style.fontWeight = 'bold';
    practicesTitle.innerHTML = 'Practice in Class for Unit ' + unitNumber;
    practiceContainer.appendChild(practicesTitle);

    practicesInClass.forEach(practice => {
        var practiceContent;
        if (typeof practice.content === 'string') {
            practiceContent = JSON.parse(practice.content)[0]; 
        } else if (practice.content) {
            practiceContent = practice.content[0]; 
        } else {
            console.error('Invalid practice format', practice);
            return;
        }

        // Add title for each practice item
        if (practiceContent.type === 'text-only') {
            var itemTitleEl = document.createElement('h3');
            itemTitleEl.style.fontSize = '25px';
            itemTitleEl.style.fontWeight = 'bold';
            itemTitleEl.style.textDecoration = 'underline';
            itemTitleEl.innerHTML = practiceContent.title; 
            practiceContainer.appendChild(itemTitleEl);

            var textContentEl = document.createElement('p');
            textContentEl.style.fontSize = '20px';
      
            
              textContentEl.innerHTML = practiceContent.content
            .replace(/(?:\r\n|\r|\n)/g, '<br>')  
            .replace(/<br>\s*•/g, '<br>&emsp;•'); 
            
            practiceContainer.appendChild(textContentEl);
        }
    });

    var selectedPracticeSection = document.getElementById('practiceInClass' + unitID);
    if (selectedPracticeSection) {
        selectedPracticeSection.innerHTML = '';
        selectedPracticeSection.appendChild(practiceContainer);
        selectedPracticeSection.style.display = 'block';
    }
}



  function showRecording(unitID) {
        // Hide all lesson, exercise, and other sections
        var lessonSections = document.querySelectorAll('.lesson-section');
        var exerciseSections = document.querySelectorAll('.exercise-section');
        var recordingSections = document.querySelectorAll('section[id^="recording"]');
        lessonSections.forEach(section => section.style.display = 'none');
        exerciseSections.forEach(section => section.style.display = 'none');
        recordingSections.forEach(section => section.style.display = 'none');

        // Show the selected recording section
        var selectedRecordingSection = document.getElementById('recording' + unitID);
        if (selectedRecordingSection) {
            selectedRecordingSection.style.display = 'block';
        }
    }

    document.addEventListener('DOMContentLoaded', function () {
      
    });
    
    
function showExercises(unitID, unitNumber, exercises) {
    var lessonSections = document.querySelectorAll('.lesson-section');
    var exerciseSections = document.querySelectorAll('.exercise-section');
    lessonSections.forEach(section => section.style.display = 'none');
    exerciseSections.forEach(section => section.style.display = 'none');

    var exerciseContainer = document.createElement('div');
    var exercisesTitle = document.createElement('h2');
    exercisesTitle.style.fontSize = '35px';
    exercisesTitle.style.fontWeight = 'bold';
    exercisesTitle.innerHTML = 'Exercise for Unit ' + unitNumber;
    exerciseContainer.appendChild(exercisesTitle);

    exercises.forEach(exercise => {
        var exerciseContent;
        if (typeof exercise.Content === 'string') {
            exerciseContent = JSON.parse(exercise.Content)[0]; 
        } else if (exercise.content) {
            exerciseContent = exercise.content[0]; 
        } else {
            console.error('Invalid exercise format', exercise);
            return;
        }

        switch (exerciseContent.type) {
            case 'multiple-choice':
                handleMultipleChoiceExercise(exerciseContent, exerciseContainer, unitID);
                break;
            case 'true-false':
                handleTrueFalseExercise(exerciseContent, exerciseContainer);
                break;
            case 'fill-blank':
                handleFillBlankExercise(exerciseContent, exerciseContainer);
                break;
            case 'essay':
                handleEssayExercise(exerciseContent, exerciseContainer);
                break;
            case 'submit-form':
                handleSubmitFormExercise(exerciseContent, exerciseContainer);
                break;
            case 'text-only':
                handleTextOnlyExercise(exerciseContent, exerciseContainer);
                break;
        
            default:
                console.warn('Unhandled exercise type:', exerciseContent.type);
        }
    });

    var selectedExerciseSection = document.getElementById('exercises' + unitID);
    if (selectedExerciseSection) {
        selectedExerciseSection.innerHTML = '';
        selectedExerciseSection.appendChild(exerciseContainer);
        selectedExerciseSection.style.display = 'block';
    }
}

function handleMultipleChoiceExercise(jsonContent, container, unitID) {
    var titleEl = document.createElement('h3');
    titleEl.style.fontSize = '25px'; // Adjust title size
    titleEl.style.fontWeight = 'bold'; // Adjust title weight
    titleEl.style.textDecoration = 'underline'; // Underline the title
    titleEl.innerHTML = jsonContent.title;
    container.appendChild(titleEl);

    Object.entries(jsonContent.question).forEach(([questionNumber, questionText]) => {
        var questionEl = document.createElement('p');
        questionEl.innerHTML = questionText;
        container.appendChild(questionEl);

        jsonContent.options[questionNumber].forEach((option, index) => {
            var optionContainer = document.createElement('div');
            var radioButton = document.createElement('input');
            radioButton.type = 'radio';
            radioButton.name = 'question' + questionNumber;
            radioButton.value = index.toString();

            var label = document.createElement('label');
            label.appendChild(radioButton);
            label.appendChild(document.createTextNode(option));
            optionContainer.appendChild(label);
            container.appendChild(optionContainer);
        });
    });

    if (!document.getElementById('submit-button-mc-' + unitID)) {
        var submitButton = document.createElement('button');
        submitButton.id = 'submit-button-mc-' + unitID;
        submitButton.textContent = 'Submit Answers';
        var scoreSpan = document.createElement('span');
        scoreSpan.id = 'score-span-' + unitID;
        scoreSpan.style.marginLeft = '10px';

        submitButton.onclick = () => checkAnswers(jsonContent, unitID, scoreSpan);

        container.appendChild(submitButton);
        container.appendChild(scoreSpan);
    }
}

function checkAnswers(jsonContent, unitID, scoreSpan) {
    let score = 0;
    const totalQuestions = Object.keys(jsonContent.correct_answers).length;

    Object.entries(jsonContent.correct_answers).forEach(([questionNumber, correctAnswerIndexes]) => {
        const userAnswer = document.querySelector(`input[name="question${questionNumber}"]:checked`);

        // Clear previous classes
        document.querySelectorAll(`input[name="question${questionNumber}"]`).forEach(input => {
            input.classList.remove('correct-answer', 'incorrect-answer');
        });

        // Apply the correct class if the answer is correct, incorrect otherwise
        if (userAnswer && correctAnswerIndexes.includes(userAnswer.value)) {
            score++;
            userAnswer.classList.add('correct-answer');
        } else if (userAnswer) {
            userAnswer.classList.add('incorrect-answer');
        }
    });

    // Update the score span
    scoreSpan.textContent = `Score: ${score}/${totalQuestions}`;
}







function handleTrueFalseExercise(exerciseContent, container) {
   
    if (exerciseContent.title) {
        var titleEl = document.createElement('h3');
        titleEl.style.fontSize = '30px';
        titleEl.style.fontWeight = 'bold';
          titleEl.style.textDecoration = 'underline';
        titleEl.innerHTML = exerciseContent.title;
        container.appendChild(titleEl);
    }


    exerciseContent.question.forEach((questionText, index) => {
        
        var questionContainer = document.createElement('div');
        questionContainer.style.display = 'flex';
        questionContainer.style.alignItems = 'center';

   
        var questionEl = document.createElement('p');
        questionEl.style.fontSize = '15px';
       // questionEl.style.fontWeight = 'bold';
        questionEl.style.marginRight = '10px';
        questionEl.innerHTML = questionText;
        questionContainer.appendChild(questionEl);

     
        var selectEl = document.createElement('select');
        selectEl.name = 'question' + (index + 1);
        selectEl.style.fontSize = '15px';

  
        var trueOption = new Option('True', 'True');
        var falseOption = new Option('False', 'False');
        selectEl.add(trueOption);
        selectEl.add(falseOption);

     
        questionContainer.appendChild(selectEl);

   
        container.appendChild(questionContainer);
    });
}

function handleFillBlankExercise(exerciseContent, container) {
 
    if (exerciseContent.title) {
        var titleEl = document.createElement('h3');
        titleEl.style.fontSize = '30px';
        titleEl.style.fontWeight = 'bold';
        titleEl.style.textDecoration = 'underline';
        titleEl.innerHTML = exerciseContent.title;
        container.appendChild(titleEl);
    }

  
    Object.entries(exerciseContent.question).forEach(([questionNumber, questionText]) => {
       
        var questionContainer = document.createElement('div');
        questionContainer.style.marginTop = '10px';

     
        var parts = questionText.split('----');

   
        for (var i = 0; i < parts.length; i++) {
     
            var textPart = document.createElement('span');
            textPart.style.fontSize = '15px';
            textPart.innerHTML = parts[i];
            questionContainer.appendChild(textPart);

            
            if (i < parts.length - 1) {
                var inputEl = document.createElement('input');
                inputEl.type = 'text';
                inputEl.name = 'question' + questionNumber + '-' + (i + 1);
                inputEl.style.fontSize = '15px';
                inputEl.style.width = '100px'; 
                questionContainer.appendChild(inputEl);
            }
        }

       
        container.appendChild(questionContainer);
    });
}

function handleEssayExercise(exerciseContent, container) {
    
    if (exerciseContent.title) {
        var titleEl = document.createElement('h3');
        titleEl.style.fontSize = '30px';
        titleEl.style.fontWeight = 'bold';
        titleEl.style.textDecoration = 'underline';
        titleEl.innerHTML = exerciseContent.title;
        container.appendChild(titleEl);
    }


    var questionEl = document.createElement('p');
    questionEl.style.fontSize = '25px';
    questionEl.innerHTML = exerciseContent.content; 
    container.appendChild(questionEl);

 
    var textAreaEl = document.createElement('textarea');
    textAreaEl.style.width = '80%'; // Reduced width to 80%
    textAreaEl.style.height = '300px'; // Increased height to 300px
    textAreaEl.style.fontSize = '15px';
    textAreaEl.name = 'essayResponse';
    container.appendChild(textAreaEl);
}

function handleSubmitFormExercise(exerciseContent, container) {
 
    if (exerciseContent.title) {
        var titleEl = document.createElement('h3');
        titleEl.style.fontSize = '30px';
        titleEl.style.fontWeight = 'bold';
        titleEl.style.textDecoration = 'underline';
        titleEl.innerHTML = exerciseContent.title;
        container.appendChild(titleEl);
    }

   
    var contentEl = document.createElement('p');
    contentEl.style.fontSize = '25px';
    contentEl.innerHTML = exerciseContent.content; 
    container.appendChild(contentEl);


    var fileInputEl = document.createElement('input');
    fileInputEl.type = 'file';
    fileInputEl.name = 'submitFormFile';
    fileInputEl.style.marginTop = '10px';
    container.appendChild(fileInputEl);
}

function handleTextOnlyExercise(exerciseContent, container) {
  
    if (exerciseContent.title) {
        var titleEl = document.createElement('h3');
        titleEl.style.fontSize = '30px';
        titleEl.style.fontWeight = 'bold';
        titleEl.style.textDecoration = 'underline';
        titleEl.innerHTML = exerciseContent.title;
        container.appendChild(titleEl);
    }


    var contentEl = document.createElement('p');
    contentEl.style.fontSize = '25px';
    contentEl.innerHTML = practiceContent.content .replace(/(?:\r\n|\r|\n)/g, '<br>')  
            .replace(/<br>\s*•/g, '<br>&emsp;•'); 
    contentEl.innerHTML = exerciseContent.content; 
    container.appendChild(contentEl);
}



</script>


<script>
 document.addEventListener('DOMContentLoaded', function () {
        var navbar = document.getElementById('navbar');
        var navLinks = document.querySelectorAll('.navbar a');
        var logoImage = document.getElementById('navbar-logo');
        var languageLinks = document.querySelectorAll('.dropdown-content a');
        var languageText = document.querySelectorAll('.selected-text');
  var hamburger = document.querySelectorAll('.hamburger');
  var dropdown = document.querySelectorAll('.dropdown-icon');

  var initialLogoSrc = '<?php echo e(asset('images/Edtech-logo-white-01-768x151-1.png')); ?>';
var scrolledLogoSrc = '<?php echo e(asset('images/Edtech-logo.png')); ?>';

        window.addEventListener('scroll', function () {
            if (window.scrollY > 0) {
                navbar.style.backgroundColor = 'white';
                navbar.style.color = 'black';

                navLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

          
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

 dropdown.forEach(function (link) {
                    link.style.color = 'black';
                });

 languageText.forEach(function (link) {
                    link.style.color = 'black';
                });

                logoImage.src = scrolledLogoSrc;
            } else {
                navbar.style.backgroundColor = 'black';
                navbar.style.color = 'white';
                navLinks.forEach(function (link) {
                    link.style.color = 'white';
                });

   
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });
 dropdown.forEach(function (link) {
                    link.style.color = 'white';
                });
 languageText.forEach(function (link) {
                    link.style.color = 'white';
                });

                logoImage.src = initialLogoSrc;
            }
        });
    });

</script>

<script>

function showUnit(unitNumber) {
    // Hide all lesson and exercise sections
    var lessonSections = document.querySelectorAll('.lesson-section');
    var exerciseSections = document.querySelectorAll('.exercise-section');
    lessonSections.forEach(function(section) {
        section.style.display = 'none';
    });
    exerciseSections.forEach(function(section) {
        section.style.display = 'none';
        section.innerHTML = ''; // Clear the content of the exercise section
    });

    // Show the selected lesson section
    var selectedSection = document.getElementById('unit' + unitNumber);
    if (selectedSection) {
        selectedSection.style.display = 'block';
    }
}

document.addEventListener('DOMContentLoaded', function () {
    showUnit(1);
});


    

</script>




</body>
</html><?php /**PATH /home2/edtechp4/public_html/edtechplusclub12102023/EdTechPlus/resources/views/Lesson.blade.php ENDPATH**/ ?>