<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Course Content Creation</title>
    
    <!-- Styles and Fonts -->
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet"> 
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="preload" href="<?php echo e(asset('images/Contact 2.jpg')); ?>" as="image">
    <link rel="icon" href="<?php echo e(asset('images/favicon.png')); ?>" type="image/x-icon">
    <link href="<?php echo e(asset('css/Contact.css')); ?>" rel="stylesheet">

 
   <style>
    body {
        background-color: #f8f9fa;
        font-family: Arial, sans-serif;
    }

    .container {
        max-width: 800px;
        margin: 0 auto;
        padding: 20px;
        background-color: white;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }

    .form-control, .form-control-file, select, textarea {
        width: 100%;
        padding: 0.5em;
        font-size: 1em;
        margin-bottom: 1em;
        box-sizing: border-box;
    }

   .field-wrapper {
            background-color: #f1f1f1;
            padding: 20px; 
            border-radius: 5px;
            margin-bottom: 1rem;
            position: relative;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

       
        .remove-field {
            position: absolute;
            right: 1px; 
            top: 1px; 
            cursor: pointer;
            color: red;
            font-size: 1.5rem;
            z-index: 0;
        }


      
    .form-control, .form-control-file, select, textarea {
        width: calc(100% - 20px); 
        padding: 0.5em;
        font-size: 1em;
        margin-bottom: 0.5em;
        box-sizing: border-box;
    }

    textarea.form-control {
        height: 150px; 
        resize: vertical; 
    }

    .text-style-options, .checkbox-group {
       
        display: flex;
        flex-wrap: wrap;
        gap: 5px;
        align-items: center;
        justify-content: flex-start;
    }

    .text-style-options > label, 
    .text-style-options > select {
        flex: 1 1 100%;
        margin-bottom: 5px; 
    }

    .checkbox-group label {
        margin-right: 10px; 
    }

    @media (max-width: 768px) {
      
        .text-style-options > label, 
        .text-style-options > select {
            width: 100%;
        }
    }
</style>


</head>

<body>
    <div id="preloader">
        <div id="logo-container">
            <img src="<?php echo e(asset('images/Edtech-logo.png')); ?>" alt="Logo">
        </div>
    </div>

    <button id="back-to-top" style="display: none;" class="scroll-top-button">&#9650;</button>

    <?php echo $__env->make('Header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="backgroundimage">
        <img src="<?php echo e(asset('images/Contact.jpg')); ?>" alt="Main Image">
    </div>

    <br><br><br>

    <?php if(session('success')): ?>
        <div class="alert alert-success" style="text-align: center; margin-top: -40px; margin-left:750px; padding: 10px; background-color: #dff0d8; border-color: #d0e9c6; color: #3c763d;">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="terms-text">
        <br><br>
        <h1>Lesson Content Form</h1>
        <br><br><br><br>
    </div>

    <div class="container mt-4">
     <form method="post" action="<?php echo e(route('storeLesson')); ?>" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
            
             <div class="form-group">
            <label for="unitSelect">Select Unit</label>
           <select id="unitSelect" name="unit_id" class="form-control">
    <option value="">Choose a Unit...</option>
    <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($unit->UnitID); ?>"><?php echo e($unit->UnitTitle); ?></option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>

        </div>
        
            <div id="content-fields">
               
            </div>
            
            <div class="btn-group">
                <button type="button" class="btn btn-primary" onclick="addField('title')">Add Title</button>
                <button type="button" class="btn btn-secondary" onclick="addField('text')">Add Text</button>
                <button type="button" class="btn btn-success" onclick="addField('image')">Add Image</button>
                <button type="button" class="btn btn-info" onclick="addField('video')">Add Video</button>
            </div>

            <input type="submit" class="btn btn-warning mt-3" value="Submit">
        </form>
    </div>

    <?php echo $__env->make('Footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <script src="<?php echo e(asset('js/Contact.js')); ?>"></script>

   <script>
    // Function to add fields dynamically
    function addField(type) {
        let container = document.getElementById('content-fields');
        let fieldWrapper = document.createElement('div');
        fieldWrapper.classList.add('field-wrapper');

        let index = container.children.length; // Get the index for the new element

        let inputGroup = document.createElement('div');
        inputGroup.classList.add(type === 'text' ? 'textarea-group' : 'text-input-group');

        if (type === 'title' || type === 'text') {
            let styleOptions = createTextStyleOptions(type, index);
            inputGroup.appendChild(styleOptions);
        }

        switch (type) {
            case 'title':
                inputGroup.innerHTML += `
                    <input type="text" name="titles[]" class="form-control" placeholder="Enter title">
                `;
                break;
            case 'text':
                inputGroup.innerHTML += `
                    <textarea name="texts[]" class="form-control" placeholder="Enter text"></textarea>
                `;
                break;
            case 'image':
                inputGroup.innerHTML += `
                    <input type="file" name="images[]" class="form-control-file">
                `;
                break;
            case 'video':
                inputGroup.innerHTML += `
                    <input type="file" name="videos[]" class="form-control-file">
                `;
                break;
            default:
                return;
        }

        let removeButton = document.createElement('span');
        removeButton.textContent = 'X';
        removeButton.classList.add('remove-field');
        removeButton.onclick = function() {
            this.parentElement.remove();
        };
        fieldWrapper.appendChild(removeButton);

        fieldWrapper.appendChild(inputGroup);
        container.appendChild(fieldWrapper);
    }

    // Function to create text style options
    function createTextStyleOptions(type, index) {
        let wrapper = document.createElement('div');
        wrapper.classList.add('text-style-options');
        
        wrapper.innerHTML = `
            <select name="${type}_colors[]" class="form-control">
                <option value="">Select Text Color</option>
                <option value="black">Black</option>
                <option value="red">Red</option>
                <option value="blue">Blue</option>
                <option value="green">Green</option>
            </select>
            <select name="${type}_sizes[]" class="form-control">
                <option value="">Select Font Size</option>
                <option value="35">35</option>
                <option value="25">25</option>
                <option value="15">15</option>
            </select>
        `;

        let checkboxGroup = document.createElement('div');
        checkboxGroup.classList.add('checkbox-group');
        
        checkboxGroup.appendChild(createCheckbox(`${type}_bold`, index, 'Bold'));
        checkboxGroup.appendChild(createCheckbox(`${type}_italic`, index, 'Italic'));
        checkboxGroup.appendChild(createCheckbox(`${type}_underline`, index, 'Underline'));
        
        wrapper.appendChild(checkboxGroup);

        return wrapper;
    }

    // Function to create individual checkbox
    function createCheckbox(name, index, label) {
        let checkbox = document.createElement('label');
        checkbox.innerHTML = `
            <input type="checkbox" name="${name}[]" value="${index}"> ${label}
        `;
        return checkbox;
    }
</script>




    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var navbar = document.getElementById('navbar');
            var navLinks = document.querySelectorAll('.navbar a');
            var logoImage = document.getElementById('navbar-logo');
            var languageLinks = document.querySelectorAll('.dropdown-content a'); 
            var languageText = document.querySelectorAll('.selected-text');
            var hamburger = document.querySelectorAll('.hamburger');
            var dropdown = document.querySelectorAll('.dropdown-icon');

            var initialLogoSrc = '<?php echo e(asset('images/Edtech-logo-white-01-768x151-1.png')); ?>';
            var scrolledLogoSrc = '<?php echo e(asset('images/Edtech-logo.png')); ?>';

            window.addEventListener('scroll', function () {
                if (window.scrollY > 0) {
                    navbar.style.backgroundColor = 'white';
                    navbar.style.color = 'black';

                    navLinks.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    languageLinks.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    dropdown.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    languageText.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    logoImage.src = scrolledLogoSrc;
                } else {
                    navbar.style.backgroundColor = 'black';
                    navbar.style.color = 'white';
                    navLinks.forEach(function (link) {
                        link.style.color = 'white';
                    });

                    languageLinks.forEach(function (link) {
                        link.style.color = 'black';
                    });

                    dropdown.forEach(function (link) {
                        link.style.color = 'white';
                    });

                    languageText.forEach(function (link) {
                        link.style.color = 'white';
                    });

                    logoImage.src = initialLogoSrc;
                }
            });
        });
    </script>
</body>
</html>
<?php /**PATH /home2/edtechp4/public_html/edtechplusclub12102023/EdTechPlus/resources/views/LessonForm.blade.php ENDPATH**/ ?>